﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using rokae.clr;

namespace xCoreSDK_CSharp.examples
{
    public class ParamDemo
    {
        internal xMateRobotDemo robotDemo;
        internal ArcWelding arcWelding;
        internal ErrorCode ec = new ErrorCode(0, "");
        internal bool toInfoBox = false;
        xMateRobot robot = new xMateRobot("192.168.0.160");


        /**
         * @brief 示例 - 测验点位接口。
         */
        public void paramsExample()
        {
            string cmd_id;

            robot.setPowerState(true, out ec);
            // getParam();
            modifyParam();


            robot.setPowerState(false, out ec);
        }

        void modifyCartPoint() {
            string name = "cartTest1";
            var position = new double[] { 1.644, 1.385, 1.103 };
            var orientation = new double[] { 0, 0, 0 };
            double elbow = 0;
            var confData = new int[] { 0, -1, 0, 0, 0, -1, 0, 0 };
            var externalAxis = new double[] { 0.2, 1, 0.56, 4, 0, 7 };
            bool res = robot.modifyCartPointByName(name, name, position, orientation, elbow, confData, externalAxis, out ErrorCode ec);
        }
        void modifyJointPoint() {
            string name = "jointTest1";
            var jointArray = new double[] { -7.8, -21.7, 36.1, 6.1, 91.3, 0, 0 };
            var externalAxis = new double[] { 1, 2, 5, 0, 0, 1.23 };
            bool res = robot.modifyJointPointByName(name, jointArray, externalAxis, out ErrorCode ec);
        }
        void modifyVar() {
            string name = "intTest1";
            string type = "int";
            string value = "45";
            bool res = robot.modifyVariableByName(name, type, value, out ErrorCode ec);
        }

        void modifyParam() {
            modifyJointPoint();
            modifyCartPoint();
            modifyVar();
        }
        void getParam() {
            var cart_name = "test_point_arr";
            var joint_name = "test_joint";
            var var_name = "double0";

            //读取变量
            var cart_arr = robot.getProjectVariable(cart_name, out ec);
            if (ec.value == 0 && cart_arr is CartesianPosition[] cartArr)
            {
                Console.WriteLine("Got array of CartesianPosition, length=" + cartArr.Length);
                foreach (var cp in cartArr)
                {
                    // cp.trans 是 double[] (Frame.trans), cp.rpy 是 double[]
                    Console.WriteLine(string.Join(",", cp.trans) + " / " + string.Join(",", cp.rpy));
                }
            }
            var joint_var = robot.getProjectVariable(joint_name, out ec);
            // JointPosition[] 或 单个 JointPosition
            if (joint_var is JointPosition[] jointArr)
            {
                Console.WriteLine("Got joint array, length=" + jointArr.Length);
                foreach (var jp in jointArr) Console.WriteLine(string.Join(",", jp.joints));
            }
            else if (joint_var is JointPosition singleJoint)
            {
                Console.WriteLine("Single joint pos: " + string.Join(",", singleJoint.joints));
            }
            // 基本类型
            var var0 = robot.getProjectVariable(var_name, out ec);
            if (var0 is double d)
            {
                Console.WriteLine("double: " + d);
            }
        }
        public void AllDemo() { 
            paramsExample();
        }
    }
}
