﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using xCoreSDK_CSharp.examples;
using System.Reflection.Metadata;
using rokae.clr;

namespace xCoreSDK_CSharp
{
    public partial class ArcWeldingForm : Form, FormInterface
    {
        ArcWeldingDemo demo;
        internal static ArcWeldingForm arcWeldingFormInstance;
        internal string InfoBox
        {
            get { return richTextBoxExecInfo.Text.ToString(); }
            set
            {
                if (richTextBoxExecInfo.InvokeRequired)
                {
                    richTextBoxExecInfo.Invoke(new Action<string>(info =>
                    {
                        AppendRichBox(this.richTextBoxExecInfo, info);
                    }), value);
                    return;
                }

                AppendRichBox(richTextBoxExecInfo, value);
            }
        }
        public ArcWeldingForm()
        {
            InitializeComponent();
            arcWeldingFormInstance = this;
        }

        void FormInterface.setRobotInstance(xMateRobotDemo robotInstance)
        {
            demo.robotDemo = robotInstance;
            try
            {
                demo.arcWelding = demo.robotDemo.robot.arcwelding();
                demo.toInfoBox = true;
            }
            catch (Exception e)
            {
                InfoBox = "需要先连接机器人";
            }
        }

        private void AppendRichBox(RichTextBox box, string content)
        {
            if (string.IsNullOrEmpty(content))
            {
                return;
            }

            box.AppendText(content + System.Environment.NewLine);
            box.ScrollToCaret();
        }

        private void PrintExecInfo(string content)
        {
            if (richTextBoxExecInfo.InvokeRequired)
            {
                richTextBoxExecInfo.Invoke(new Action<string>(info =>
                {
                    AppendRichBox(this.richTextBoxExecInfo, info);
                }), content);
                return;
            }

            AppendRichBox(richTextBoxExecInfo, content);
        }

        private void printErrorCode(string operate, ErrorCode _ec)
        {
            if (_ec.value != 0)
            {
                PrintExecInfo(operate + ": " + _ec.message);
            }
        }

        private void ArcWeldingForm_Load(object sender, EventArgs e)
        {
            demo = new ArcWeldingDemo();
        }

        private void btnArcOnDataExample_Click(object sender, EventArgs e)
        {
            demo.SetArcOnDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnArcDataExample_Click(object sender, EventArgs e)
        {
            demo.SetArcDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnArcOffDataExample_Click(object sender, EventArgs e)
        {
            demo.SetArcOffDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnWeaveDataExample_Click(object sender, EventArgs e)
        {
            demo.SetWeaveDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnSegDataExample_Click(object sender, EventArgs e)
        {
            demo.SetSegDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnLaserTrackDataExample_Click(object sender, EventArgs e)
        {
            demo.SetLaserTrackDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnLaserSearchDataExample_Click(object sender, EventArgs e)
        {
            demo.SetLaserSearchDataExample(demo.arcWelding, ref demo.ec);
        }

        private void btnIOExample_Click(object sender, EventArgs e)
        {
            demo.SetIOSettingExample(demo.arcWelding, ref demo.ec);
        }

        private void buttonClearLog_Click(object sender, EventArgs e)
        {
            richTextBoxExecInfo.Clear();
        }
    }
}
