MODULE MOD_MAIN
GLOBAL VAR zone Z500=s{500,100}
GLOBAL PROC main()
	SingAreaLockAxis4 on
    BackHome()

    WHILE(True)
        // 右侧托盘 Right pallet
        IF (flagR1 == 0)
            IF (DI2_0 == true || enableStackR == true) // 按下启动按钮且启用右侧码垛
                WaitUntil (enableStackR == true && DI2_6 == true && DI3_0 == true && flagR == 0) // 右侧未满垛，检测到右侧托盘且物料到位才开始码垛
                palletStatus = 2
                YouMaDuo()
                palletStatus = 0
            Endif
        Endif

        // 检查右侧托盘是否已满 Check if the right pallet is full
        IF (flagR == 1) // Right pallet is full
            flagR1 = 1
        Endif
    endwhile
ENDPROC

// DO3_3 左侧球形灯蜂鸣器，处理码垛情况
// DO3_7 右侧球形灯蜂鸣器，处理异常情况

// DI 信号定义
// 启动按钮：2-0
// 停止按钮：2-1
// 复位按钮：2-2
// 左箭头按钮：2-3
// 右箭头按钮：2-4
// 左托盘到位检测：2-5
// 右托盘到位检测：2-6
// 激光扫描仪 1 输入 1：2-8
// 激光扫描仪 1 输入 2：2-9
// 激光扫描仪 1 输入 3：2-10
// 激光扫描仪 2 输入 1：2-11
// 激光扫描仪 2 输入 2：2-12
// 激光扫描仪 2 输入 3：2-13
// 气压检测反馈：2-15
// 输送线到位检测：3-0

// DO 信号定义
// 启动灯：2-0
// 停止灯：2-1
// 复位灯：2-2
// 左箭头灯：2-3
// 右箭头灯：2-4
// 吸盘开启：2-6
// 安全扫描仪 1 区域 1：2-10
// 安全扫描仪 1 区域 2：2-11
// 安全扫描仪 2 区域 1：2-12
// 安全扫描仪 2 区域 2：2-13
// 左侧球形红灯：3-0
// 左侧球形黄灯：3-1
// 左侧球形绿灯：3-2
// 左侧球形灯蜂鸣器：3-3
// 右侧球形红灯：3-4
// 右侧球形黄灯：3-5
// 右侧球形绿灯：3-6
// 右侧球形灯蜂鸣器：3-7
// 电机正转：3-8
// 电机翻转：3-9


// enableStackL 和 enableStackR 这两个 bool 类型的 PERS 变量，分别表示左右侧是否启用码垛
// 以下与左侧码垛相关的 PERS 变量：
//     1. 当前配方所对应的序号 - int - palletIndexL
//     2. 单托盘已码个数 - int - palletCountL
//     3. 总托盘数量 - int - palletTotalCountL
//     4. 当前码放层数 - int - currentLayerL
//     5. 当前层已码放个数 - int - layerCountL
//     6. 累计已码托盘数量 - int - totalPalletsL
//     7. 累计已码放个数 - int - totalPiledCountL
//     8. 单个码垛节拍 - double - cycleTimeL
//     9. 左侧箱子高度 - int - boxHeightL
// 以下与右侧码垛相关的 PERS 变量：
//     1. 当前配方所对应的序号 - int - palletIndexR
//     2. 单托盘已码个数 - int - palletCountR
//     3. 总托盘数量 - int - palletTotalCountR
//     4. 当前码放层数 - int - currentLayerR
//     5. 当前层已码放个数 - int - layerCountR
//     6. 累计已码托盘数量 - int - totalPalletsR
//     7. 累计已码放个数 - int - totalPiledCountR
//     8. 单个码垛节拍 - double - cycleTimeR
//     9. 右侧箱子高度 - int - boxHeightR
// 与托盘状态相关的 PERS 变量：
//     1. 托盘状态 - int - palletStatus （1 表示左侧，2 表示右侧）
// 与 IO 状态相关的 PERS 变量：
//     1. 左侧已满标志 - int - flagL
//     2. 右侧已满标志 - int - flagR
//     3. 左侧备用标志 - int - flagL1
//     4. 右侧备用标志 - int - flagR1
//     5. 举升柱状态 - int - rise （1 表示上升，0 表示下降）
//     6. 是否使用举升柱 - int - use_rise
//     7. 码垛最大高度 - int - SetZ
//     8. 机器人码垛场景下可达的最大高度 - int - MaxZ
//     9. 抓取物料 - bool - grabbing
// 与码垛场景相关的 PERS 变量：
//     1. 距离待机点的距离 - int - Margin
//     2. 抬升高度 - int - liftHeight
// 普通变量：
//     1. 时钟变量 - clock - clock0
//     2. 箱子高度 - int - boxheight
//     3. 当前位置 - robtarget - BHOME
//     4. 左侧标志位 - bool - flagLL
//     5. 右侧标志位 - bool - flagRR
//     6. 通用标志位 - bool - flag

ENDMODULE