GLOBAL PROC BackHome()

boxheight = 300 // 箱子高度，默认300mm Box height, default 300mm

// 获取码垛工具 Get palletizing tool
 
PalletUpdate(recipeNameR, 1, 1)
PalletUpdateTool(recipeNameR, 1,  1, false, 0)
BHOME = CRobT(PalletTool, Wobj0)

If(BHOME.trans.y <= 0)

Else if(BHOME.trans.y > 0) // 机器人末端处于右侧托盘 Robot end effector is on the right pallet
	 

	// 确保 currentLayerR 和 layerCountR 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerR and layerCountR do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerR <= PalletLayerCount(recipeNameR))
		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	Else
		currentLayerR = PalletLayerCount(recipeNameR)

		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameR, currentLayerR, layerCountR)

	boxheight = boxHeightR

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool
		ENDIF

		MoveL PalletEnterPoint, v4000, z200, PalletTool
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

Endif
ENDPROC
