GLOBAL VAR zone Z500=s{500,100}
GLOBAL PROC main()
	SingAreaLockAxis4 on  //  4-axis lock command
    BackHome()
	AutoIgnoreZone false   //The control system is not allowed to automatically ignore the turning zone.
    CompletePostureLerp On   // Enable the parallel base
    WHILE(True)
        //  Left pallet    
        IF (flagL1 == 0&&(DI2_0 == true || enableStackL == true))// Press the start button and enable the left palletizing
		   
			if (enableStackL == true && DI2_5 == true && DI3_0 == true&&DI3_2 == false && flagL == 0)  //Left side not fully stacked; pallet detected on the left side and material in position before palletizing starts                
				palletStatus=1   // Run the left palletizing status bit
				ZuoMaDuo()
				
				palletStatus=0   // Clear the status bit
			else if (enableStackL == true && DI2_5 == true && DI3_0 == true&&DI3_2 == true && flagL == 0) //Left side not fully stacked; pallet detected on the left side and material in position before palletizing starts         
                palletStatus=1   // Run the left palletizing status bit
				ZuoMaDuo()
				
				palletStatus=0   // Clear the status bit
				if(flagR == 0&&enableStackR == true)    // The right side is not fully palletized and the right palletizing function is enabled
					palletStatus=2    // Run the right palletizing status bit
					YouMaDuo()
				
					palletStatus=0   // Clear the status bit
				Endif
            Endif
        Endif

        // Right pallet  
        IF (flagR1 == 0&&(DI2_0 == true || enableStackR == true)) // Press the start button and enable the right side palletizing
              if (enableStackR == true && DI2_6 == true && (DI3_0 == false||flagL == 1) && DI3_2 == true && flagR == 0)  // The right side is not fully stacked. Stacking only begins when the right pallet is detected and the materials are in place   
                palletStatus=2    // Run the right palletizing status bit
				YouMaDuo() 
				palletStatus=0    // Clear the status bit
            Endif
        Endif
		
		//No material was detected
		if ( DI3_0 == false && DI3_2 == false)     // Neither of the two assembly lines has a signal for material detection
			MoveL PalletHomePoint, v4000, z200, PalletTool //  Move to material pickup standby point
			waituntil(DI3_0 == true || DI3_2 == true)	 	 // Wait for a signal from either the left or right sensor
		endif
	
        //  Check if both pallets are full
        IF (flagL == 1 && flagR == 1) // Both pallets are full
            flagL1 = 1   //Left Flag Bit for Simultaneous Full Stack on Left and Right Sides
            flagR1 = 1    //Right Flag Bit for Simultaneous Full Stack on Left and Right Sides
		Endif
    endwhile
ENDPROC


// DI signal definitions
// Start button: 2-0
// Stop button: 2-1
// Reset button: 2-2
// Left arrow button: 2-3
// Right arrow button: 2-4
// Left pallet in-position detection: 2-5
// Right pallet in-position detection: 2-6
// Laser scanner 1 input 1: 2-8
// Laser scanner 1 input 2: 2-9
// Laser scanner 1 input 3: 2-10
// Laser scanner 2 input 1: 2-11
// Laser scanner 2 input 2: 2-12
// Laser scanner 2 input 3: 2-13
// Air pressure feedback: 2-15
// Conveyor in-position detection: 3-0

// DO signal definitions
// Start lamp: 2-0
// Stop lamp: 2-1
// Reset lamp: 2-2
// Left arrow lamp: 2-3
// Right arrow lamp: 2-4
// Suction cup ON: 2-6
// Safety scanner 1 area 1: 2-10
// Safety scanner 1 area 2: 2-11
// Safety scanner 2 area 1: 2-12
// Safety scanner 2 area 2: 2-13
// Left stacklight red: 3-0
// Left stacklight yellow: 3-1
// Left stacklight green: 3-2
// Left stacklight buzzer: 3-3
// Right stacklight red: 3-4
// Right stacklight yellow: 3-5
// Right stacklight green: 3-6
// Right stacklight buzzer: 3-7
// Motor forward: 3-8
// Motor reverse: 3-9

// DO3_3 Left stacklight buzzer — handle palletizing status
// DO3_7 Right stacklight buzzer — handle abnormal/fault conditions

// The two bool PERS variables enableStackL and enableStackR indicate whether palletizing is enabled on the left and right sides, respectively.

// PERS variables related to LEFT-side palletizing:
//   1) Recipe index for the current recipe - int - palletIndexL
//   2) Count on the current pallet - int - palletCountL
//   3) Total number of pallets - int - palletTotalCountL
//   4) Current layer number - int - currentLayerL
//   5) Count placed on the current layer - int - layerCountL
//   6) Cumulative pallets completed - int - totalPalletsL
//   7) Cumulative items placed - int - totalPiledCountL
//   8) Single-cycle palletizing time - double - cycleTimeL
//   9) Left-side box height - int - boxHeightL

// PERS variables related to RIGHT-side palletizing:
//   1) Recipe index for the current recipe - int - palletIndexR
//   2) Count on the current pallet - int - palletCountR
//   3) Total number of pallets - int - palletTotalCountR
//   4) Current layer number - int - currentLayerR
//   5) Count placed on the current layer - int - layerCountR
//   6) Cumulative pallets completed - int - totalPalletsR
//   7) Cumulative items placed - int - totalPiledCountR
//   8) Single-cycle palletizing time - double - cycleTimeR
//   9) Right-side box height - int - boxHeightR

// PERS variables related to pallet status:
//   1) Pallet side status - int - palletStatus (1 = left, 2 = right)

// PERS variables related to IO status:
//   1) Left-side full flag - int - flagL
//   2) Right-side full flag - int - flagR
//   3) Left-side spare flag - int - flagL1
//   4) Right-side spare flag - int - flagR1
//   5) Lifting column status - int - rise (1 = up, 0 = down)
//   6) Use lifting column - int - use_rise
//   7) Max palletizing height - int - SetZ
//   8) Max reachable height in robot palletizing scenario - int - MaxZ
//   9) Grabbing material - bool - grabbing

// PERS variables related to the palletizing scene:
//   1) Distance to standby point - int - Margin
//   2) Lift height - int - liftHeight

// General variables:
//   1) Clock variable - clock - clock0
//   2) Box height - int - boxheight
//   3) Current position - robtarget - BHOME
//   4) Left-side flag - bool - flagLL
//   5) Right-side flag - bool - flagRR
//   6) General/commons flag - bool - flag
