GLOBAL PROC YouMaDuo()
    flagRR = true

     
	AccSet 40,100
    // Get palletizing tool
    PalletUpdate(recipeNameR, 1, 1)   //Obtain the Right Palletizing Name and the Position of the First Workpiece in the First Layer
    PalletUpdateTool(recipeNameR, currentLayerR,  layerCountR, false, 0)     //Update the Current Tool and Load
    MoveL PalletHomePoint, v4000, z500, PalletTool //  Move to material pickup standby point

	CompletePostureLerp On     //Command to activate the parallel base

    //  Start timing
    PalletClkReset(recipeNameR)

    // Start palletizing
    while (currentLayerR <= PalletLayerCount(recipeNameR))
        VAR jointtarget Approach // Define joint angle variable
        Approach = CalcJointT(PalletGetApproachPoint ,PalletTool,wobj0) // Get the joint angles at the material pickup approach point
        // Palletizing layer loop
        while (layerCountR <= PalletWobjCount(recipeNameR, currentLayerR))
            //  Update relevant points
            PalletUpdate(recipeNameR, currentLayerR, layerCountR)            

            // Material pickup path
           MoveAbsJ Approach,v4000,z500,PalletTool//  Material pickup approach point
           // MoveL offs(PalletGetApproachPoint, 0, 0, 0), v4000, z500, PalletTool // Material pickup approach point
            waituntil(DI3_0 == true) // Wait for material in place
            MoveL offs(PalletGetWobjPoint, 0, 0, 0), v4000, fine, PalletTool // Material pickup point
            PalletUpdateTool(recipeNameR, currentLayerR,  layerCountR, true, 1)    //Update the Current Tool and Load
            HandingLoadChange DO2_6, true, PalletTool.tload, 0 // Suction cup pneumatic suction
            wait getDelayTime // Ensure that the suction action is complete
            grabbing = true
            MoveL offs(PalletGetApproachPoint, 0, 0, 0), speed0, z500, PalletTool //  Material pickup approach point

            // Material placement path
            MoveL PalletEnterPoint, speed0, z500, PalletTool // Material placement entry point
            MoveL PalletReadyPoint, speed0, z500, PalletTool // Material placement ready point
            MoveL offs(PalletApproachPoint, 0, 0, 0), v4000, z500, PalletTool // Material placement approach point
            MoveL offs(PalletWobjPoint, 0, 0, 0), v4000, fine, PalletTool // Material placement point
            grabbing = false
            PalletUpdateTool(recipeNameR, currentLayerR,  layerCountR, false, 0)  //Update the Current Tool and Load
			SetDO DO2_7,true       //Blow Air
            HandingLoadChange DO2_6, false, PalletTool.tload, 0 //  Suction cup pneumatic release
            wait putDelayTime //  Ensure that the release action is complete

            palletCountR++ // Accumulate tray count
            layerCountR++ // Accumulate layer count

            MoveL offs(PalletExitPoint, 0, 0, 0), speed0, z500, PalletTool // Material placement exit point
			SetDO DO2_7,false
            MoveL PalletEnterPoint, speed0, z500, PalletTool // Material placement entry point
            MoveAbsJ Approach,v4000,z500,PalletTool// Material pickup approach point
//			MoveL offs(PalletGetApproachPoint, 0, 0, 0), v4000, z500, PalletTool //  Material pickup approach point

            //  Stop timing
            PalletClkRead(recipeNameR, cycleTimeR)
            // ClkStop clock0
            // cycleTimeR = ClkRead(clock0)
            // ClkReset clock0

        endwhile

        layerCountR = 1 // Complete one layer of palletizing, clear the layer count
        currentLayerR++ //  Accumulate layer count

        IF((currentLayerR == PalletLayerCount(recipeNameR) + 1)) //  Check for full pallet
            flagR = 1 // Full pallet

            totalPalletsR++ // Accumulate total tray count

            palletCountR = 0 // Clear tray count

            MoveL PalletHomePoint, v4000, z500, PalletTool // Move to material pickup standby point
        else
            flagR = 0 // Not full pallet
        endif
    endwhile
    CompletePostureLerp Off     //Command to deactivate the parallel base
ENDPROC
