MODULE MOD_HELPER
GLOBAL PROC Helper()
    clearAlarm()  //Call the Alarm Clearance Function
    powerOff()  //Call the Lifting Column Power-Off Function
    setModeToPosition()  //Call the Operation Mode Setting Function
    powerOn()
    //while(true)
    moveTo(66170*30,7000*80,true)//6617=1mm Maximum 520 mm, coefficient range (0, 520)

    //endwhile
    powerOff()  //Call the Lifting Column Power-Off Function
    wait 1
    pause
ENDPROC

GLOBAL PROC powerOn()
	if(ModesOfOperation==3)  //If the Operation Mode Is Speed Mode (3 Represents Speed Mode)
		moveAtCertainSpeed(0)  //Operate at the Specified Speed
	endif
	WriteRegByName(ControlwordWrite,6)  //Write 6 to the Control Word Register
	wait 0.01
	WriteRegByName(ControlwordWrite,7)  //Write 7 to the Control Word Register
	wait 0.01
	WriteRegByName(ControlwordWrite,15)//Write 15 to the Control Word Register (Writing 6, 7, 15 in Sequence Is the Power-On Command)
	wait 1
ENDPROC

GLOBAL PROC powerOff()
	WriteRegByName(ControlwordWrite,0)  //Write 0 to the Control Word Register (Writing 0 Is the Power-Off Command)
	wait 1
ENDPROC

GLOBAL PROC setModeToPosition()
	WriteRegByName(OperationModeWrite,1)  //Write 1 to the Operation Mode Register
ENDPROC

GLOBAL PROC moveTo(int target_position,int velocity,bool is_synchronous)//Send position coordinates
	if(ControlwordWrite!=15)//On power-up, continue operation if power is restored; if not powered, power on
	        powerOn()   //Call the Power-On Function
		    endif
	flag=0
	waituntil(PointAcknowledge==0)  //Wait for the Position Confirmation Register to Be 0
	WriteRegByName(ProfileAcceleWrite,-1)  //Write -1 to the Acceleration Register
	WriteRegByName(ProfileDeceWrite,-1)  //Write -1 to the Deceleration Register
	WriteRegByName(ProfileVelocityWrite,velocity)  //Write the Obtained Speed to the Speed Register
	WriteRegByName(PositionWrite,target_position)//Write the Target Encoder Position to the Encoder Position Register
	WriteRegByName(ControlwordWrite,31)  //Write 31 to the Control Word Register (Writing 31 on the basis of the original value 15 is the Motion Start Command)
	wait 0.01
	WriteRegByName(ControlwordWrite,15)  //Write 15 to the Control Word Register
	wait 0.01
	if(is_synchronous)  //If it is synchronous
		waituntil(TargetReached==1&&PointAcknowledge==0)  //Wait for the Lifting Column to Reach the Target Position
	endif
ENDPROC

GLOBAL PROC setModeTospeed()
	WriteRegByName(OperationModeWrite,3)  //Write 3 to the Operation Mode Register (3 Represents Speed Mode)
ENDPROC

GLOBAL PROC moveAtCertainSpeed(int velocity)
	WriteRegByName(ProfileAcceleWrite,-1)  //Write -1 to the Acceleration Register
	WriteRegByName(ProfileDeceWrite,-1) // Write -1 to the Deceleration Register
	WriteRegByName(VelocityWrite, velocity)  //Write the Obtained Speed to the Speed Register
ENDPROC

GLOBAL PROC clearAlarm()
	int srcControlword   //Read the Control Word
	ReadRegByName(ControlwordWrite,srcControlword)//Read the value of the Control Word Register into the controller variable
	WriteRegByName(ControlwordWrite,srcControlword+128)  //Write the read value plus 128 to the Control Word Register
	wait 0.01
	WriteRegByName(ControlwordWrite,srcControlword)  //Write the read value to the Control Word Register
ENDPROC
ENDMODULE