MODULE MOD_HELPER
GLOBAL PROC Helper()
    clearAlarm()    //调用清除报警函数
    powerOff()  //调用升降柱下电函数
    setModeToPosition()    //调用设置操作模式函数
    powerOn()  //调用升降柱上电函数
    //while(true)
    moveTo(6617*1,7000*80,true)//6617=1mm   最大520mm,系数(0,52)
    //endwhile
    powerOff() //调用升降柱下电函数
    wait 1
    pause
ENDPROC

GLOBAL PROC powerOn() 
	if(ModesOfOperation==3)   //如果操作模式为速度模式（3为速度模式）
		moveAtCertainSpeed(0)   //以指定的速度运行
	endif
	WriteRegByName(ControlwordWrite,6)   //把控制字寄存器写入为6
	wait 0.01
	WriteRegByName(ControlwordWrite,7)   //把控制字寄存器写入为7
	wait 0.01
	WriteRegByName(ControlwordWrite,15)  //把控制字寄存器写入为15（顺序写入6.7.15为上电指令）
	wait 1
ENDPROC

GLOBAL PROC powerOff()
	WriteRegByName(ControlwordWrite,0)     //把控制字寄存器写入为0（写入为0为下电指令）
	wait 1
ENDPROC

GLOBAL PROC setModeToPosition()
	WriteRegByName(OperationModeWrite,1)  //将1写入操作模式寄存器
ENDPROC

GLOBAL PROC moveTo(int target_position,int velocity,bool is_synchronous)    //发送位置坐标 Send position coordinates
	if(ControlwordWrite!=15)//上电，如果上电继续运行
		powerOn()  //调用上电函数
    endif
	flag=0
	waituntil(PointAcknowledge==0)    //等待位置确认寄存器为0
	WriteRegByName(ProfileAcceleWrite,-1)   //将-1写入加速度寄存器
	WriteRegByName(ProfileDeceWrite,-1)   //将-1写入减速度寄存器
	WriteRegByName(ProfileVelocityWrite,velocity) //将获取的速度写入速度寄存器
	WriteRegByName(PositionWrite,target_position)  //将目标编码器位置写入到编码器位置寄存器
	WriteRegByName(ControlwordWrite,31)   //把控制字寄存器写入为31（在原值15的状态下写入31为开始运动指令）
	wait 0.01
	WriteRegByName(ControlwordWrite,15)   //把控制字寄存器写入为15
	wait 0.01
	if(is_synchronous) //如果是同步的
		waituntil(TargetReached==1&&PointAcknowledge==0)   //等待升降柱到位
	endif
ENDPROC

GLOBAL PROC setModeTospeed()
	WriteRegByName(OperationModeWrite,3) //将3写入操作模式寄存器（3为速度模式）
ENDPROC

GLOBAL PROC moveAtCertainSpeed(int velocity)
	WriteRegByName(ProfileAcceleWrite,-1)   //将-1写入加速度寄存器
	WriteRegByName(ProfileDeceWrite,-1)      //将-1写入减速度寄存器
	WriteRegByName(VelocityWrite, velocity)  //将获取的速度写入速度寄存器
ENDPROC

GLOBAL PROC clearAlarm()
	int srcControlword
	ReadRegByName(ControlwordWrite,srcControlword)    //将控制字寄存器的值读取到控制器变量中
	WriteRegByName(ControlwordWrite,srcControlword+128)   //将读取到的值+128写入到控制字寄存器中
	wait 0.01
	WriteRegByName(ControlwordWrite,srcControlword)    //将读取到的值写入到控制字寄存器中
ENDPROC
ENDMODULE