GLOBAL PROC BackHome()

boxheight = 300 // 箱子高度，默认300mm Box height, default 300mm

// 获取码垛工具 Get palletizing tool
 
PalletUpdate(recipeNameL, 1, 1)     //获取左码垛名称及第一层的第一个工件的点位
PalletUpdateTool(recipeNameL, 1,  1, false, 0)//更新当前工具和负载
BHOME = CRobT(PalletTool, Wobj0)  //获取当前点位

If(BHOME.trans.y <= 0) // 机器人末端处于左侧托盘 Robot end effector is on the left pallet
	 

	// 确保 currentLayerL 和 layerCountL 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerL <= PalletLayerCount(recipeNameL))       //判断左侧当前层是否小于等于左侧当前配方总数
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))    //判断左侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)    //将当前配方的当前层的工件总数赋值给左侧待码工件数
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)   //将左侧当前配方总数赋值给左侧当前层

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))  //判断左侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)   //将当前配方的当前层的工件总数赋值给左侧待码工件数
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)    //判断获取的当前值的Z值加上盒子的高度是否小于设定的最大值
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool  //如果小于为真抬升一个箱子高度
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool  //否则不抬升
		ENDIF

		MoveL PalletEnterPoint, v4000, z200, PalletTool  //运动到当前进入点
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

Else if(BHOME.trans.y > 0)

Endif
ENDPROC
