GLOBAL PROC BackHome()

boxheight = 300 // Box height, default 300mm

//Get palletizing tool
 
PalletUpdate(recipeNameL, 1, 1)  //Obtain the Left Palletizing Name and the Position of the First Workpiece in the First Layer
PalletUpdateTool(recipeNameL, 1,  1, false, 0)   //Update the Current Tool and Load
BHOME = CRobT(PalletTool, Wobj0)   //Obtain the Current Position

If(BHOME.trans.y <= 0) //  Robot end effector is on the left pallet
	 

	// Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
IF (currentLayerL <= PalletLayerCount(recipeNameL))  //Determine Whether the Current Left Layer Is Less Than or Equal to the Total Number of Current Left Recipes
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))  //Determine Whether the Current Sequence Number of Workpieces to Be Palletized on the Left Is Greater Than the Total Number of Workpieces in the Current Layer of the Current Recipe
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)  //Determine Whether the Current Sequence Number of Left Pending Palletizing Workpieces Exceeds the Total Number of Workpieces in the Current Layer of the Current Recipe
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)  //Assign the Total Number of Current Left Recipes to the Current Left Layer

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL)) // Determine Whether the Current Sequence Number of Left Pending Palletizing Workpieces Exceeds the Total Number of Workpieces in the Current Layer of the Current Recipe
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)  //Assign the Total Number of Workpieces in the Current Layer of the Current Recipe to the Number of Left Pending Palletizing Workpieces
		endif
	endif

	// Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	// If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)   //Determine Whether the Z-Value of the Obtained Current Value Plus the Height of the Box Is Less Than the Set Maximum Value
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool   //If Less Than Is True, Lift by One Box Height
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool   //Otherwise, Do Not Lift
		ENDIF

		MoveL PalletEnterPoint, v4000, z200, PalletTool     //Move to the Current Entry Point
	ENDIF

	// Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

Else if(BHOME.trans.y > 0)   //Robot end effector is on the right pallet

Endif
ENDPROC
