GLOBAL PROC BackHome()
powerOn()  //升降柱上电函数
boxheight = 300 // 箱子高度，默认300mm Box height, default 300mm

// 获取码垛工具 Get palletizing tool
PalletUpdate(recipeNameL, 1, 1)    //获取左码垛名称及第一层的第一个工件的点位
PalletUpdateTool(recipeNameL, 1,  1, false, 0)   //更新当前工具和负载
BHOME = CRobT(PalletTool, Wobj0)      //获取当前点位

If(BHOME.trans.y <= 0) // 机器人末端处于左侧托盘 Robot end effector is on the left pallet

	// 确保 currentLayerL 和 layerCountL 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerL <= PalletLayerCount(recipeNameL))      //判断左侧当前层是否小于等于左侧当前配方总数
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))    //判断左侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)     //将当前配方的当前层的工件总数赋值给左侧待码工件数
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)     //将左侧当前配方总数赋值给左侧当前层

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))   //判断左侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)     //将当前配方的当前层的工件总数赋值给左侧待码工件数
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)   //判断获取的当前值的Z值加上盒子的高度是否小于设定的最大值
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool    //如果小于为真抬升一个箱子高度
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool    //否则不抬升
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))     //判断准备点的Z值是否大于设定的Z值
			rise = 1  //抬升状态 Rising state
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ)) //如果准备点的Z值小于等于设定的Z值
			rise = 0   //下降状态 Descending state
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool   //运动到当前进入点
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// 判断当前层是否需要抬升升降柱 Determine whether the current layer needs to rise or fall
	IF(( PalletReadyPoint.trans.z > SetZ))
		use_rise = 1    //启用升降柱

		endL:
			clearAlarm()   //调用清除报警函数
//			powerOff()
			setModeToPosition()     //调用设置操作模式函数
//			powerOn()
			moveTo(6617 * liftHeight, 7000 * 80,true)    // 发送位置坐标 Send position coordinates
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)       //判断升降柱是否到位
			Goto endL    //程序跳转到标签endL
		endif

		rise = 1 // 抬升状态 Rising state
		use_rise = 0    //启用升降柱为假
	ELSE if((PalletReadyPoint.trans.z <= SetZ))      //如果准备点Z值小于等于设定的Z值
		use_rise = 1     //启用升降柱为真

		endLL:
			clearAlarm()     //调用清除报警函数
//			powerOff()
			setModeToPosition()    //调用设置操作模式函数
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)     //抬升升降柱   
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)      //判断升降柱是否到位
			Goto endLL      //程序跳转到标签endLL
		endif

		rise = 0 // 下降状态 Descending state
		use_rise = 0     //不使用升降柱
	endif

Else if(BHOME.trans.y > 0) // 机器人末端处于右侧托盘 Robot end effector is on the right pallet

	// 确保 currentLayerR 和 layerCountR 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerR and layerCountR do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerR <= PalletLayerCount(recipeNameR))   //判断右侧当前层是否小于等于右侧当前配方总数
		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))  //判断右侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)    //将当前配方的当前层的工件总数赋值给右侧待码工件数
		endif
	Else
		currentLayerR = PalletLayerCount(recipeNameR)   //将右侧当前配方总数赋值给右侧当前层

		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))   //判断右侧当前待码工件序号是否大于当前配方的当前层的工件总数
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)    //将当前配方的当前层的工件总数赋值给右侧待码工件数
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameR, currentLayerR, layerCountR)

	boxheight = boxHeightR

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)      //判断获取的当前值的Z值加上盒子的高度是否小于设定的最大值
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool     //如果小于为真抬升一个箱子高度
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool    //否则不抬升
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))     //如果准备点Z值大于设定的Z值
			rise = 1  //上升状态Rising state
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))  //如果准备点Z值小于等于设定的Z值
			rise = 0  //下降状态  Descending state
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool   //运动到当前进入点
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// 判断当前层是否需要抬升升降柱 Determine whether the current layer needs to rise or fall
	IF(( PalletReadyPoint.trans.z > SetZ))
		use_rise = 1   // 启用升降柱

		endR:
			clearAlarm()   //调用清除报警函数
//			powerOff()
			setModeToPosition()   //调用设置操作模式函数
//			powerOn()
			moveTo(6617 * liftHeight, 7000 * 80,true)   // 发送位置坐标 Send position coordinates
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)      //判断升降柱是否到位
			Goto endR      //程序跳转到标签endR
		endif

		rise = 1 // 抬升状态 Rising state
		use_rise = 0  //不启用升降柱
	ELSE if(( PalletReadyPoint.trans.z <= SetZ))    //判断准备点的Z值用于判断是否抬升升降柱
		use_rise = 1  //启用升降柱

		endRR:
			clearAlarm()     //调用清除报警函数
//			powerOff()
			setModeToPosition()    //调用设置操作模式函数
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)    //抬升升降柱
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)    //判断升降柱是否到位
			Goto endRR    //程序跳转到标签endRR
		endif

		rise = 0 // 下降状态 Descending state
		use_rise = 0  //不启用升降柱
	endif

Endif
ENDPROC
