MODULE MOD_BACKHOME
GLOBAL PROC BackHome()
powerOn()
boxheight = 300 //Box height, default 300mm

// Get palletizing tool
 
PalletUpdate(recipeNameL, 1, 1)
PalletUpdateTool(recipeNameL, 1,  1, false, 0)
BHOME = CRobT(PalletTool, Wobj0)

If(BHOME.trans.y <= 0) //Robot end effector is on the left pallet
	 

	//Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerL <= PalletLayerCount(recipeNameL))
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)
		endif
	endif

	// Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	// If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))
			rise = 1
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))
			rise = 0
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool
	ENDIF

	//Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// Determine whether the current layer needs to rise or fall
	IF((PalletReadyPoint.trans.z > SetZ))
		use_rise = 1

		endL:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * liftHeight, 6617 * 80,true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)
			Goto endL
		endif

		rise = 1 //Rising state
		use_rise = 0
	ELSE if((PalletReadyPoint.trans.z <= SetZ))
		use_rise = 1

		endLL:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)
			Goto endLL
		endif

		rise = 0 //Descending state
		use_rise = 0
	endif

Else if(BHOME.trans.y > 0) //Robot end effector is on the right pallet
	 

	// Ensure that the values of currentLayerR and layerCountR do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerR <= PalletLayerCount(recipeNameR))
		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	Else
		currentLayerR = PalletLayerCount(recipeNameR)

		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	endif

	// Update related points
	PalletUpdate(recipeNameR, currentLayerR, layerCountR)

	boxheight = boxHeightR

	//If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))
			rise = 1
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))
			rise = 0
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool
	ENDIF

	//Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// Determine whether the current layer needs to rise or fall
	IF((PalletReadyPoint.trans.z > SetZ))
		use_rise = 1

		endR:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * liftHeight, 7000 * 80,true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)
			Goto endR
		endif

		rise = 1 // Rising state
		use_rise = 0
	ELSE if(( PalletReadyPoint.trans.z <= SetZ))
		use_rise = 1

		endRR:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)
			Goto endRR
		endif

		rise = 0 // Descending state
		use_rise = 0
	endif

Endif
ENDPROC

ENDMODULE