MODULE MOD_MAIN
GLOBAL VAR zone Z500=s{500,100}   //Change the turning area to Z500.
GLOBAL PROC main()
	
    BackHome() //BackHome
	
    WHILE(True)
        IF (DI2_3==true&&DI2_4==false)   //Press the left arrow button
			palletStatus = 1  // Run the left palletizing status bit
		Endif
		IF(DI2_4==true&&DI2_3==false)  //Press the right arrow button
			palletStatus = 2  // Run the right palletizing status bit
		Endif
		
        //Left pallet
        IF (enableStackL == true) // Enable left-side palletizing
    IF (flagL1 == 0 && flagL == 0 && palletStatus == 1 && DI2_5 == true)  // Left stack not full, left palletizing status bit active, and left pallet in place
        WaitUntil (enableStackL == true && DI3_0 == true && flagL == 0) // Start palletizing only when the left side is not full, the left pallet is detected, and material is in place
        ZuoMaDuo()
        palletStatus = 2   // Run the right palletizing status bit
    Endif
Endif

// Right pallet
IF (enableStackR == true) // Enable right-side palletizing
    IF (flagR1 == 0 && flagR == 0 && palletStatus == 2 && DI2_6 == true)// Right stack not full, right palletizing status active, and right pallet in place
        WaitUntil (enableStackR == true && DI3_0 == true && flagR == 0) // Start palletizing only when the right side is not full, the right pallet is detected, and material is in place
        YouMaDuo()
        palletStatus = 1  // Run the left palletizing status bit
    Endif
Endif


        //Check if both pallets are full
        IF (flagL == 1 && flagR == 1) // Both pallets are full
            flagL1 = 1  // Left flag bit for both left and right stacks being full
            flagR1 = 1  // Right flag bit for both left and right stacks being full
        Endif
    endwhile
ENDPROC

// DI signal definitions
// Start button: 2-0
// Stop button: 2-1
// Reset button: 2-2
// Left arrow button: 2-3
// Right arrow button: 2-4
// Left pallet in-position detection: 2-5
// Right pallet in-position detection: 2-6
// Laser scanner 1 input 1: 2-8
// Laser scanner 1 input 2: 2-9
// Laser scanner 1 input 3: 2-10
// Laser scanner 2 input 1: 2-11
// Laser scanner 2 input 2: 2-12
// Laser scanner 2 input 3: 2-13
// Air pressure feedback: 2-15
// Conveyor in-position detection: 3-0

// DO signal definitions
// Start lamp: 2-0
// Stop lamp: 2-1
// Reset lamp: 2-2
// Left arrow lamp: 2-3
// Right arrow lamp: 2-4
// Suction cup ON: 2-6
// Safety scanner 1 area 1: 2-10
// Safety scanner 1 area 2: 2-11
// Safety scanner 2 area 1: 2-12
// Safety scanner 2 area 2: 2-13
// Left stacklight red: 3-0
// Left stacklight yellow: 3-1
// Left stacklight green: 3-2
// Left stacklight buzzer: 3-3
// Right stacklight red: 3-4
// Right stacklight yellow: 3-5
// Right stacklight green: 3-6
// Right stacklight buzzer: 3-7
// Motor forward: 3-8
// Motor reverse: 3-9

// DO3_3 Left stacklight buzzer — handle palletizing status
// DO3_7 Right stacklight buzzer — handle abnormal conditions

// The bool PERS variables enableStackL and enableStackR indicate whether palletizing is enabled on the left and right sides, respectively.

// PERS variables related to LEFT-side palletizing:
//   1) Recipe index for the current recipe - int - palletIndexL
//   2) Count on the current pallet - int - palletCountL
//   3) Total number of pallets - int - palletTotalCountL
//   4) Current layer number - int - currentLayerL
//   5) Count placed on the current layer - int - layerCountL
//   6) Cumulative pallets completed - int - totalPalletsL
//   7) Cumulative items placed - int - totalPiledCountL
//   8) Single-cycle palletizing time - double - cycleTimeL
//   9) Left-side box height - int - boxHeightL

// PERS variables related to RIGHT-side palletizing:
//   1) Recipe index for the current recipe - int - palletIndexR
//   2) Count on the current pallet - int - palletCountR
//   3) Total number of pallets - int - palletTotalCountR
//   4) Current layer number - int - currentLayerR
//   5) Count placed on the current layer - int - layerCountR
//   6) Cumulative pallets completed - int - totalPalletsR
//   7) Cumulative items placed - int - totalPiledCountR
//   8) Single-cycle palletizing time - double - cycleTimeR
//   9) Right-side box height - int - boxHeightR

// PERS variables related to pallet status:
//   1) Pallet side status - int - palletStatus (1 = left, 2 = right)

// PERS variables related to IO status:
//   1) Left-side full flag - int - flagL
//   2) Right-side full flag - int - flagR
//   3) Left-side spare flag - int - flagL1
//   4) Right-side spare flag - int - flagR1
//   5) Lifting column status - int - rise (1 = up, 0 = down)
//   6) Use lifting column - int - use_rise
//   7) Max palletizing height - int - SetZ
//   8) Max reachable height in robot palletizing scenario - int - MaxZ
//   9) Grabbing material - bool - grabbing

// PERS variables related to the palletizing scene:
//   1) Distance to the standby point - int - Margin
//   2) Lift height - int - liftHeight

// General variables:
//   1) Clock variable - clock - clock0
//   2) Box height - int - boxheight
//   3) Current position - robtarget - BHOME
//   4) Left-side flag - bool - flagLL
//   5) Right-side flag - bool - flagRR
//   6) General flag - bool - flag
ENDMODULE