GLOBAL VAR zone Z500=s{500,100}
GLOBAL PROC main()
    BackHome()   // BackHome

    WHILE(True)
        // Left pallet
        IF (flagL1 == 0)
            IF (DI2_0 == true || enableStackL == true) // Press the start button and enable left palletizing
                WaitUntil (enableStackL == true && DI2_5 == true && DI3_0 == true && flagL == 0) // Left pallet not full, pallet detected and material ready before palletizing
                palletStatus = 1    // Run the left palletizing status bit
                ZuoMaDuo()
                palletStatus = 0 // Clear the status bit
            Endif
        Endif

        // Check if the left pallet is full
        IF (flagL == 1) // Left pallet is full
            flagL1 = 1// Left flag bit for both left and right stacks being full
        Endif
    endwhile
ENDPROC


// DI signal definitions
// Start button: 2-0
// Stop button: 2-1
// Reset button: 2-2
// Left arrow button: 2-3
// Right arrow button: 2-4
// Left pallet in-position detection: 2-5
// Right pallet in-position detection: 2-6
// Laser scanner 1 input 1: 2-8
// Laser scanner 1 input 2: 2-9
// Laser scanner 1 input 3: 2-10
// Laser scanner 2 input 1: 2-11
// Laser scanner 2 input 2: 2-12
// Laser scanner 2 input 3: 2-13
// Air pressure feedback: 2-15
// Conveyor in-position detection: 3-0

// DO signal definitions
// Start light: 2-0
// Stop light: 2-1
// Reset light: 2-2
// Left arrow light: 2-3
// Right arrow light: 2-4
// Suction cup ON: 2-6
// Safety scanner 1 area 1: 2-10
// Safety scanner 1 area 2: 2-11
// Safety scanner 2 area 1: 2-12
// Safety scanner 2 area 2: 2-13
// Left spherical red light: 3-0
// Left spherical yellow light: 3-1
// Left spherical green light: 3-2
// Left spherical light buzzer: 3-3
// Right spherical red light: 3-4
// Right spherical yellow light: 3-5
// Right spherical green light: 3-6
// Right spherical light buzzer: 3-7
// Motor forward: 3-8
// Motor reverse: 3-9

// DO3_3 Left spherical light buzzer, handles palletizing state
// DO3_7 Right spherical light buzzer, handles abnormal conditions

// enableStackL and enableStackR are bool PERS variables indicating whether left and right palletizing are enabled
// Left palletizing related PERS variables:
//     1. Recipe index - int - palletIndexL
//     2. Items stacked on one pallet - int - palletCountL
//     3. Total pallet count - int - palletTotalCountL
//     4. Current stacking layer - int - currentLayerL
//     5. Items stacked in the current layer - int - layerCountL
//     6. Total stacked pallets - int - totalPalletsL
//     7. Total stacked items - int - totalPiledCountL
//     8. Single palletizing cycle time - double - cycleTimeL
//     9. Left box height - int - boxHeightL
// Right palletizing related PERS variables:
//     1. Recipe index - int - palletIndexR
//     2. Items stacked on one pallet - int - palletCountR
//     3. Total pallet count - int - palletTotalCountR
//     4. Current stacking layer - int - currentLayerR
//     5. Items stacked in the current layer - int - layerCountR
//     6. Total stacked pallets - int - totalPalletsR
//     7. Total stacked items - int - totalPiledCountR
//     8. Single palletizing cycle time - double - cycleTimeR
//     9. Right box height - int - boxHeightR
// Pallet status related PERS variables:
//     1. Pallet status - int - palletStatus (1 for left, 2 for right)
// IO status related PERS variables:
//     1. Left pallet full flag - int - flagL
//     2. Right pallet full flag - int - flagR
//     3. Left spare flag - int - flagL1
//     4. Right spare flag - int - flagR1
//     5. Lifting column status - int - rise (1 for up, 0 for down)
//     6. Use lifting column - int - use_rise
//     7. Max palletizing height - int - SetZ
//     8. Max reachable height for robot palletizing - int - MaxZ
//     9. Grabbing material flag - bool - grabbing
// Palletizing environment related PERS variables:
//     1. Distance from standby point - int - Margin
//     2. Lifting height - int - liftHeight
// General variables:
//     1. Clock variable - clock - clock0
//     2. Box height - int - boxheight
//     3. Current position - robtarget - BHOME
//     4. Left side flag - bool - flagLL
//     5. Right side flag - bool - flagRR
//     6. General flag - bool - flag
