GLOBAL PROC BackHome()
powerOn()
boxheight = 300 //Box height, default 300mm

//Get palletizing tool
 
PalletUpdate(recipeNameL, 1, 1)  //Obtain the Left Palletizing Name and the Position of the First Workpiece in the First Layer
PalletUpdateTool(recipeNameL, 1,  1, false, 0)   //Update the Current Tool and Load
BHOME = CRobT(PalletTool, Wobj0)   //Obtain the Current Position

If(BHOME.trans.y <= 0) //Robot end effector is on the left pallet
	 

	//Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerL <= PalletLayerCount(recipeNameL))  //Determine Whether the Current Left Layer Is Less Than or Equal to the Total Number of Current Left Recipes
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))  //Determine Whether the Current Sequence Number of Workpieces to Be Palletized on the Left Is Greater Than the Total Number of Workpieces in the Current Layer of the Current Recipe
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)  //Determine Whether the Current Sequence Number of Left Pending Palletizing Workpieces Exceeds the Total Number of Workpieces in the Current Layer of the Current Recipe
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)  //Assign the Total Number of Current Left Recipes to the Current Left Layer

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL)) // Determine Whether the Current Sequence Number of Left Pending Palletizing Workpieces Exceeds the Total Number of Workpieces in the Current Layer of the Current Recipe
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)  //Assign the Total Number of Workpieces in the Current Layer of the Current Recipe to the Number of Left Pending Palletizing Workpieces
		endif
	endif

	//Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	//If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)  //Determine Whether the Z-Value of the Obtained Current Value Plus the Height of the Box Is Less Than the Set Maximum Value
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool  //If Less Than Is True, Lift by One Box Height
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool    //Otherwise, Do Not Lift
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))    //Determine Whether the Z-Value of the Preparation Point Is Greater Than the Set Z-Value
			rise = 1
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))   //If the Z-Value of the Preparation Point Is Less Than or Equal to the Set Z-Value
			rise = 0
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool   //Move to the Current Entry Point
	ENDIF

	//Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	//Determine whether the current layer needs to rise or fall
	IF(( PalletReadyPoint.trans.z > SetZ))
		use_rise = 1     //Status of Lifting Columns

		endL:
			clearAlarm()  //Call the Alarm Clearance Function
//			powerOff()
			setModeToPosition()  //Call the Operation Mode Setting Function
//			powerOn()
			moveTo(6617 * liftHeight, 7000 * 80,true)    //Send position coordinates
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)    // Timeout or position error greater than 1000
			Goto endL    // Program Jumps to Label endL
		endif

		rise = 1 // Rising state
		use_rise = 0    //Disable the Lifting Columns
	ELSE if(( PalletReadyPoint.trans.z <= SetZ))   // If the Z-Value of the Preparation Point Is Less Than or Equal to the Set Z-Value
		use_rise = 1    // Enable the Lifting Columns

		endLL:
			clearAlarm()  //Call the Alarm Clearance Function
//			powerOff()
			setModeToPosition()   //Call the Operation Mode Setting Function
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)   //Send position coordinates
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)     // Timeout or position error greater than 1000
			Goto endLL     // Program Jumps to Label endLL
		endif

		rise = 0 // Descending state
		use_rise = 0    //Disable the Lifting Columns
	endif

Else if(BHOME.trans.y > 0)   //Robot end effector is on the right pallet

Endif
ENDPROC
