MODULE MOD_YOUMADUO
GLOBAL PROC YouMaDuo()
	flagRR = true
AutoIgnoreZone false    // The control system is not allowed to automatically ignore the turning zone

	boxheight = boxHeightR
	AccSet 40,100
	//  Get palletizing tool
	PalletUpdate(recipeNameR, 1, 1)    //Obtain the Right Palletizing Name and the Position of the First Workpiece in the First Layer
	PalletUpdateTool(recipeNameR, currentLayerR,  layerCountR, false, 0)  //Update the current tool and load
    MoveL PalletHomePoint, v4000, z500, PalletTool // Move to material pickup standby point

	CompletePostureLerp On    //Command to activate the parallel base

	// Start timing
	PalletClkReset(recipeNameR)

	// Start palletizing
    while (currentLayerR <= PalletLayerCount(recipeNameR))


		// Palletizing layer loop
        while (layerCountR <= PalletWobjCount(recipeNameR, currentLayerR))
		//Update relevant points - concentric tools share the same picking path
			PalletUpdate(recipeNameR, currentLayerR, layerCountR)

			//  Material pickup path
			MoveL offs(PalletGetApproachPoint, 0, 0, 0), v4000, z500, PalletTool // Material pickup approach point
			waituntil(DI3_0 == true) // Wait for material in place
			MoveL offs (PalletGetWobjPoint, 0, 0, 0), v4000, fine, PalletTool // Material pickup point

			// Get the number of items to pick - input: recipe name, layer index, workpiece index - currently either two or one
			int grab_number = GetGrabNumber(recipeNameR, currentLayerR, layerCountR)
		// The actual load should take the number of picked items into account
			PalletUpdateTool(recipeNameR, currentLayerR,  layerCountR, true, grab_number)

			// The first element in the bin array corresponds to the suction cup closest to the baffle
				// Get the suction signal value to be sent (binToDec) - input: recipe name, layer index, workpiece index - currently either [1, 1] → 3 or [1, 0] → 2
				int grab_bin_to_dec = GetGrabSignalValue(recipeNameR, currentLayerR, layerCountR)
				// Updated to use GO: 3 indicates picking two items simultaneously, 2 indicates picking one item (using the suction cup closest to the baffle). Currently, simultaneous picking can only be 3 or 2
				HandingLoadChangeGO signal0, grab_bin_to_dec, PalletTool.tload, 0 // Suction cup pneumatic suction
				// print("Simultaneous pick and release || Simultaneous pick with sequential placement", PalletTool)
				wait getDelayTime // Ensure the suction action is complete
			grabbing = true

			MoveL offs(PalletGetApproachPoint, 0, 0, 0), speed0, z500, PalletTool // Material pickup approach point
			MoveL offs(PalletEnterPoint,0,0,0), speed0, z500, PalletTool // Material placement entry point
			int all_release_number = 0  // Keeps track of how many workpieces have been placed; used to compare with the picked count to determine different handling logic
			// layerCountL
			while (all_release_number < grab_number) // Ensure the loop exits only after all picked items have been placed
				// Update placement-related positions based on the current workpiece index; this loop skips points depending on the number of items placed each time
				PalletUpdate(recipeNameR, currentLayerR, layerCountR)

				// Material placement path
				MoveL offs(PalletReadyPoint,0,0,0), speed0, z500, PalletTool // Material placement ready point
				MoveL offs(PalletApproachPoint, 0, 0, 0), v4000, z500, PalletTool // Material placement approach point
				MoveL offs(PalletWobjPoint, 0, 0, 0), v4000, fine, PalletTool // Material placement point

				// Get the number of items to place - input: recipe name, layer index, workpiece index
				int cur_release_number = GetReleaseNumber(recipeNameR, currentLayerR, layerCountR)
				all_release_number = all_release_number + cur_release_number  // Increment the count of released items

				if (all_release_number == grab_number)// Simultaneous pick and place, or simultaneous pick with sequential placement; the second placement triggers (simultaneous pick with one-by-one placement type 2)
					PalletUpdateTool(recipeNameR, currentLayerR, layerCountR, false, 0) //Update the current tool and load

					HandingLoadChangeGO signal0, 0, PalletTool.tload, 0 // Suction cup pneumatic release
					grabbing = false
//  print("Simultaneous pick and release || Simultaneous pick with sequential placement", PalletTool)
					SetDO DO2_7, true    //Blow Air
					wait putDelayTime // Ensure the release action is complete
					// In multi-pick cases, this variable is set to false only after all workpieces have been placed
				else // Multi-pick with sequential placement
					// Update the actual load before each placement
					PalletUpdateTool(recipeNameR, currentLayerR, layerCountR, true, grab_number - all_release_number)

					// The first element in the bin array corresponds to the suction cup closest to the baffle
					// Get the placement signal value to be sent (binToDec) - input: recipe name, layer index, workpiece index - in dual-pick sequential mode, the first placement is [0, 1] → 1 (place the first workpiece first)
					int release_bin_to_dec = GetReleaseSignalValue(recipeNameR, currentLayerR, layerCountR) // 1 (multi-pick single-place type 1)
					HandingLoadChangeGO signal0, release_bin_to_dec, PalletTool.tload, 0 // Suction cup pneumatic suction
	//  print("Simultaneous pick with one-by-one placement 1", PalletTool)
					SetDO DO2_7,true    //Blow Air
					wait putDelayTime // Ensure that the release action is complete
				endif

				palletCountR = palletCountR + cur_release_number // Increment the pallet count - currently either add 1 or add 2
				layerCountR = layerCountR + cur_release_number  // Increment the layer count - currently either add 1 or add 2

				MoveL offs(PalletExitPoint, 0, 0, 0), speed0, z500, PalletTool //  Material placement exit point
			endwhile
			SetDO DO2_7,false      // Stop Blowing Air
			MoveL offs(PalletEnterPoint,0,0,0), speed0, z500, PalletTool // Material placement entry point

			MoveL offs(PalletGetApproachPoint, 0, 0, 0), v4000, z500, PalletTool // Material pickup approach point

			//  Stop timing
//			PalletClkRead(recipeNameR, cycleTimeR)
			// ClkStop clock0
			// cycleTimeL = ClkRead(clock0)
			// ClkReset clock0
	endwhile

        layerCountR = 1 // Complete one layer of palletizing, clear the layer count
        currentLayerR++ // Accumulate layer count

		IF((currentLayerR == PalletLayerCount(recipeNameR) + 1)) //  Check for full pallet
			flagR = 1 // Full pallet

			totalPalletsR++ // Accumulate total tray count

			palletCountR = 0 // Clear tray count

			MoveL PalletHomePoint, v4000, z500, PalletTool // Move to material pickup standby point


	    else
			flagR = 0 //  Not full pallet
	    endif
    endwhile
    CompletePostureLerp Off    //Command to deactivate the parallel base
ENDPROC

ENDMODULE