GLOBAL VAR zone Z500=s{500,100}
GLOBAL PROC main()
    BackHome()

    WHILE(True)
        // Right pallet
        IF (flagR1 == 0)
            IF (DI2_0 == true || enableStackR == true) // Press start button and enable right palletizing
                WaitUntil (enableStackR == true && DI2_6 == true && DI3_0 == true && flagR == 0) // Right side not full, pallet detected and material in place before starting palletizing
                palletStatus = 2
                YouMaDuo()
                palletStatus = 0
            Endif
        Endif

        // Check if the right pallet is full
        IF (flagR == 1) // Right pallet is full
            flagR1 = 1
        Endif
    endwhile
ENDPROC

// DO3_3 Left spherical light buzzer, handles palletizing condition
// DO3_7 Right spherical light buzzer, handles abnormal condition

// DI signal definition
// Start button: 2-0
// Stop button: 2-1
// Reset button: 2-2
// Left arrow button: 2-3
// Right arrow button: 2-4
// Left pallet position detection: 2-5
// Right pallet position detection: 2-6
// Laser scanner 1 input 1: 2-8
// Laser scanner 1 input 2: 2-9
// Laser scanner 1 input 3: 2-10
// Laser scanner 2 input 1: 2-11
// Laser scanner 2 input 2: 2-12
// Laser scanner 2 input 3: 2-13
// Air pressure feedback: 2-15
// Conveyor in-place detection: 3-0

// DO signal definition
// Start light: 2-0
// Stop light: 2-1
// Reset light: 2-2
// Left arrow light: 2-3
// Right arrow light: 2-4
// Suction cup activation: 2-6
// Safety scanner 1 zone 1: 2-10
// Safety scanner 1 zone 2: 2-11
// Safety scanner 2 zone 1: 2-12
// Safety scanner 2 zone 2: 2-13
// Left spherical red light: 3-0
// Left spherical yellow light: 3-1
// Left spherical green light: 3-2
// Left spherical light buzzer: 3-3
// Right spherical red light: 3-4
// Right spherical yellow light: 3-5
// Right spherical green light: 3-6
// Right spherical light buzzer: 3-7
// Motor forward rotation: 3-8
// Motor reverse rotation: 3-9

// enableStackL and enableStackR are two bool-type PERS variables representing whether palletizing is enabled on the left and right sides respectively
// The following PERS variables are related to the left palletizing process:
//     1. Recipe index - int - palletIndexL
//     2. Pallets stacked per tray - int - palletCountL
//     3. Total pallet quantity - int - palletTotalCountL
//     4. Current stacking layer - int - currentLayerL
//     5. Items stacked in current layer - int - layerCountL
//     6. Total stacked trays - int - totalPalletsL
//     7. Total stacked items - int - totalPiledCountL
//     8. Single palletizing cycle time - double - cycleTimeL
//     9. Left box height - int - boxHeightL
// The following PERS variables are related to the right palletizing process:
//     1. Recipe index - int - palletIndexR
//     2. Pallets stacked per tray - int - palletCountR
//     3. Total pallet quantity - int - palletTotalCountR
//     4. Current stacking layer - int - currentLayerR
//     5. Items stacked in current layer - int - layerCountR
//     6. Total stacked trays - int - totalPalletsR
//     7. Total stacked items - int - totalPiledCountR
//     8. Single palletizing cycle time - double - cycleTimeR
//     9. Right box height - int - boxHeightR
// PERS variables related to pallet status:
//     1. Pallet status - int - palletStatus (1 for left, 2 for right)
// PERS variables related to IO status:
//     1. Left full flag - int - flagL
//     2. Right full flag - int - flagR
//     3. Left auxiliary flag - int - flagL1
//     4. Right auxiliary flag - int - flagR1
//     5. Lifting column status - int - rise (1 for up, 0 for down)
//     6. Lifting column enable flag - int - use_rise
//     7. Maximum stacking height - int - SetZ
//     8. Maximum reachable height in robot palletizing scenario - int - MaxZ
//     9. Grabbing material - bool - grabbing
// PERS variables related to the palletizing scenario:
//     1. Distance from standby point - int - Margin
//     2. Lifting height - int - liftHeight
// General variables:
//     1. Clock variable - clock - clock0
//     2. Box height - int - boxheight
//     3. Current position - robtarget - BHOME
//     4. Left flag - bool - flagLL
//     5. Right flag - bool - flagRR
//     6. General flag - bool - flag
