MODULE MOD_HELPER
GLOBAL PROC Helper()
    clearAlarm()
    powerOff()
    setModeToPosition()
    powerOn()
    //while(true)
    //moveTo(70000*0,70000*5,true)//58720260=10mm   Maximum 600mm, coefficient (0,60)
    moveTo(66170*20,70000*5,true)//58720260=10mm  Maximum 600mm, coefficient (0,60)
    //endwhile
    powerOff()
    wait 1
    pause
ENDPROC

GLOBAL PROC powerOn()
	if(ModesOfOperation==3)
		moveAtCertainSpeed(0)
	endif
	WriteRegByName(ControlwordWrite,6)
	wait 0.01
	WriteRegByName(ControlwordWrite,7)
	wait 0.01
	WriteRegByName(ControlwordWrite,15)
	wait 1
ENDPROC

GLOBAL PROC powerOff()
	WriteRegByName(ControlwordWrite,0)
	wait 1
ENDPROC

GLOBAL PROC setModeToPosition()
	WriteRegByName(OperationModeWrite,1)
ENDPROC

GLOBAL PROC moveTo(int target_position,int velocity,bool is_synchronous)
	if(ControlwordWrite!=15)//Power on. If powered on, continue to operate
	powerOn()
    endif
	flag=0
	waituntil(PointAcknowledge==0)
	WriteRegByName(ProfileAcceleWrite,-1)
	WriteRegByName(ProfileDeceWrite,-1)
	WriteRegByName(ProfileVelocityWrite,velocity)
	WriteRegByName(PositionWrite,target_position)
	WriteRegByName(ControlwordWrite,31)
	wait 0.01
	WriteRegByName(ControlwordWrite,15)
	wait 0.01
	if(is_synchronous)
		waituntil(TargetReached==1&&PointAcknowledge==0)
	endif
ENDPROC

GLOBAL PROC setModeTospeed()
	WriteRegByName(OperationModeWrite,3)
ENDPROC

GLOBAL PROC moveAtCertainSpeed(int velocity)
	WriteRegByName(ProfileAcceleWrite,-1)
	WriteRegByName(ProfileDeceWrite,-1)
	WriteRegByName(VelocityWrite, velocity)
ENDPROC

GLOBAL PROC clearAlarm()
	int srcControlword
	ReadRegByName(ControlwordWrite,srcControlword)
	WriteRegByName(ControlwordWrite,srcControlword+128)
	wait 0.01
	WriteRegByName(ControlwordWrite,srcControlword)
ENDPROC

ENDMODULE