GLOBAL PROC BackHome()
powerOn()
boxheight = 300 // 箱子高度，默认300mm Box height, default 300mm

// 获取码垛工具 Get palletizing tool
 
PalletUpdate(recipeNameL, 1, 1)
PalletUpdateTool(recipeNameL, 1,  1, false, 0)
BHOME = CRobT(PalletTool, Wobj0)

If(BHOME.trans.y <= 0) // 机器人末端处于左侧托盘 Robot end effector is on the left pallet
	 

	// 确保 currentLayerL 和 layerCountL 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerL and layerCountL do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerL <= PalletLayerCount(recipeNameL))
		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)
		endif
	else
		currentLayerL = PalletLayerCount(recipeNameL)

		IF (layerCountL > PalletWobjCount(recipeNameL, currentLayerL))
			layerCountL = PalletWobjCount(recipeNameL, currentLayerL)
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameL, currentLayerL, layerCountL)

	boxheight = boxHeightL

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))
			rise = 1
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))
			rise = 0
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// 判断当前层是否需要抬升升降柱 Determine whether the current layer needs to rise or fall
	IF((PalletReadyPoint.trans.z > SetZ))
		use_rise = 1

		endL:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * liftHeight, 6617 * 80,true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)
			Goto endL
		endif

		rise = 1 // 抬升状态 Rising state
		use_rise = 0
	ELSE if((PalletReadyPoint.trans.z <= SetZ))
		use_rise = 1

		endLL:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)
			Goto endLL
		endif

		rise = 0 // 下降状态 Descending state
		use_rise = 0
	endif

Else if(BHOME.trans.y > 0) // 机器人末端处于右侧托盘 Robot end effector is on the right pallet
	 

	// 确保 currentLayerR 和 layerCountR 的值不超过托盘的层数和当前层的物件数 Ensure that the values of currentLayerR and layerCountR do not exceed the number of layers of the pallet and the number of objects in the current layer
	IF (currentLayerR <= PalletLayerCount(recipeNameR))
		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	Else
		currentLayerR = PalletLayerCount(recipeNameR)

		IF (layerCountR > PalletWobjCount(recipeNameR, currentLayerR))
			layerCountR = PalletWobjCount(recipeNameR, currentLayerR)
		endif
	endif

	// 更新相关点位 Update related points
	PalletUpdate(recipeNameR, currentLayerR, layerCountR)

	boxheight = boxHeightR

	// 如果末端在取料待机点附近，不走进入点位 If the end is near the pick-up standby point, do not go to the entry point
	IF(abs(BHOME.trans.x - PalletHomePoint.trans.x) > Margin || abs(BHOME.trans.y - PalletHomePoint.trans.y) > 1000 || abs(BHOME.trans.z - PalletHomePoint.trans.z) > Margin)
		IF(BHOME.trans.z + boxheight < MaxZ)
			MoveL Offs(BHOME, 0, 0, boxheight), v4000, z200, PalletTool
		else
			MoveL Offs(BHOME, 0, 0, 0), v4000, z200, PalletTool
		ENDIF

		IF((PalletEnterPoint.trans.z > SetZ || PalletReadyPoint.trans.z > SetZ))
			rise = 1
		ELSE if((PalletEnterPoint.trans.z <= SetZ && PalletReadyPoint.trans.z <= SetZ))
			rise = 0
		endif

		MoveL offs(PalletEnterPoint, 0, 0, 0 - liftHeight * rise), v4000, z200, PalletTool
	ENDIF

	// 移动到取料待机点 Move to the pick-up standby point
	MoveL PalletHomePoint, v4000, z200, PalletTool

	// 判断当前层是否需要抬升升降柱 Determine whether the current layer needs to rise or fall
	IF((PalletReadyPoint.trans.z > SetZ))
		use_rise = 1

		endR:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * liftHeight, 7000 * 80,true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * liftHeight) > 1000)
			Goto endR
		endif

		rise = 1 // 抬升状态 Rising state
		use_rise = 0
	ELSE if(( PalletReadyPoint.trans.z <= SetZ))
		use_rise = 1

		endRR:
			clearAlarm()
//			powerOff()
			setModeToPosition()
//			powerOn()
			moveTo(6617 * 1, 7000 * 80, true)
//			powerOff()
			wait 0.5

		if(flag == true || abs(PositionRead - 6617 * 1) > 1000)
			Goto endRR
		endif

		rise = 0 // 下降状态 Descending state
		use_rise = 0
	endif

Endif
ENDPROC
