MODULE MOD_MAIN
GLOBAL PROC main()
	/*
	  * @note  在DEMO模式，会自动建立一个socket与HMI交互数据
	  *				如果想使用RL模式调试DEMO的网络任务
	  *				需要打开下面代码的注释，使用网络助手与其连接
	  *				具体下发数据参考 http://confluence.i.rokae.com/pages/viewpage.action?pageId=28969422
	  */
	//SocketClose(socket_name)
	//SocketCreate("127.0.0.1", 1010, socket_name, 5)

	double db_arr[16]
	while(true)
		db_arr = SocketReadDouble(16, 3600, socket_name)	// socket_name 来自定义文件
	
		while(true)
			if (!at_ready_pos)
				wait 0.1
			else
				break
			endif
		endwhile
		
		// 调节碰撞检测灵敏度
		if (db_arr[1] > 0)
			// 目前只有motionsup指令可以调节碰撞灵敏度，假设新的指令是 MotionSupPlus
			// 更改灵敏度
			MotionSupPlus db_arr[6], db_arr[7], db_arr[8], db_arr[9], db_arr[10], db_arr[11], db_arr[12]
			// print("碰撞检测调节: ", db_arr)
		endif

		// 调节柔顺度
		if (db_arr[2] > 0)
			// 更新位置指令
			ResetCmdPos
        	// 设置阻抗刚度 ，前3轴刚度(0~1500)，后3轴刚度(0~100)
           	SetCartCtrlStiffVec db_arr[6], db_arr[7], db_arr[8], db_arr[9], db_arr[10], db_arr[11]
           	SetCartNSStiff db_arr[12]
           	// 调节柔顺的指令
          	//print("柔顺调节: ", db_arr)
    	endif
		// ...
		// 后续其他可以调节的demo
		// ...
		
		// 防止频繁参数调节
		wait 0.5
	endwhile
ENDPROC

ENDMODULE