# -*- coding: utf-8 -*-
"""
@file: hmi_disconnection_behavior_example.py
@brief: 设置hmi断连行为示例
@copyright: Copyright (C) 2024 ROKAE (Beijing) Technology Co., LTD. All Rights Reserved.
Information in this file is the intellectual property of Rokae Technology Co., Ltd,
And may contains trade secrets that must be stored and viewed confidentially.
"""
import setup_path
import platform
# 根据操作系统导入相应的模块
if platform.system() == 'Windows':
    from Release.windows import xCoreSDK_python
elif platform.system() == 'Linux':
    from Release.linux import xCoreSDK_python
else:
    raise ImportError("Unsupported operating system")
from log import print_log, print_separator
from move_example import wait_robot


def move():
    robot.setPowerState(True, ec)
    id = xCoreSDK_python.PyString()
    j1 = xCoreSDK_python.JointPosition([1, 1, 1, 1, 1, 1])
    absj = xCoreSDK_python.MoveAbsJCommand(j1)
    robot.moveAppend(absj, id, ec)
    robot.moveStart(ec)
    wait_robot(robot, ec)


# 打印回调信息
def print_hmi_disconnection_behavior_state(info):
    print("enter print_hmi_disconnection_behavior_state")
    behavior = info[
        xCoreSDK_python.EventInfoKey.DisconnectionBehaviour.Behaviour]
    detect_time = info[
        xCoreSDK_python.EventInfoKey.DisconnectionBehaviour.DetectTime]
    print(f"callback. behavior: {behavior}, detect_time: {detect_time}")


# 设置hmi断连行为
def set_hmi_disconnection_behavior():
    # 设置回调信息
    robot.setEventWatcher(xCoreSDK_python.Event.disconnectionBehaviour,
                          print_hmi_disconnection_behavior_state, ec)

    # 设置hmi断连行为
    robot.setHmiDisconnectBehaviour(1, 100, ec)  # hmi断连后停机

    # 获取hmi断连行为
    behavior, detect_time = robot.getHmiDisconnectBehaviour(ec)
    print(
        f"getHmiDisconnectBehaviour. behavior: {behavior}, detect_time: {detect_time}"
    )

    move()
    print("move finished")


robot = xCoreSDK_python.xMateRobot()
ec = {}
if __name__ == '__main__':
    try:
        # 连接机器人
        # 不同的机器人对应不同的类型
        ip = "192.168.0.160"
        robot.connectToRobot(ip)
        set_hmi_disconnection_behavior()
        robot.setNoneEventWatcher(xCoreSDK_python.Event.disconnectionBehaviour,
                                  ec)  # 程序结束时需要主动取消回调
    except Exception as e:
        print(f"An error occurred: {e}")
