from __future__ import annotations
import datetime
import pybind11_stubgen.typing_ext
import typing
import xCoreSDK_python
__all__ = ['Amplitude', 'AntiWireStickParam', 'AnticollisionState', 'ArcBreakParam', 'ArcData', 'ArcOffCommand', 'ArcOffData', 'ArcOnCommand', 'ArcOnData', 'ArcSetOpt', 'ArcTrackParam', 'ArcWeldRunningParam', 'ArcWelding', 'CRNT', 'CalibrationResult', 'CharacteristicCurveData', 'ElevationAngle', 'FeedBackWireCommand', 'FeedOnWireCommand', 'HandeyeData', 'INTELLIGENT', 'IOData', 'IOSetting', 'LaserSearchCommand', 'LaserSearchData', 'LaserSensorCfg', 'LaserSensorType', 'LaserTrackData', 'LaserTrackOffCommand', 'LaserTrackOnCommand', 'LrTrackParam', 'ReArcOnParam', 'Real', 'SMART_IMAGE', 'ScratchArconParam', 'SegData', 'SegOffCommand', 'SegOnCommand', 'Simu', 'TestRun', 'UdTrackParam', 'WMoveCCommand', 'WMoveCFCommand', 'WMoveLCommand', 'WMoveLPendulumCommand', 'WeaveAdaptiveData', 'WeaveData', 'WeaveOffCommand', 'WeaveOnCommand', 'WeldMode', 'WelderSetting', 'WelderStatus']
class Amplitude:
    """
    摆动幅度
    """
    def __init__(self) -> None:
        ...
    @property
    def left(self) -> float:
        """
        左幅度。单位：mm，范围：[0.1, 50]
        """
    @left.setter
    def left(self, arg0: float) -> None:
        ...
    @property
    def right(self) -> float:
        """
        右幅度。单位：mm，范围：[0.1, 50]
        """
    @right.setter
    def right(self, arg0: float) -> None:
        ...
class AntiWireStickParam:
    """
    防粘丝参数
    """
    def __init__(self) -> None:
        ...
    @property
    def current(self) -> float:
        """
        防粘丝电流。单位：A，范围：[0 - 100]
        """
    @current.setter
    def current(self, arg0: float) -> None:
        ...
    @property
    def enable(self) -> bool:
        """
        防粘丝开关
        """
    @enable.setter
    def enable(self, arg0: bool) -> None:
        ...
    @property
    def time(self) -> int:
        """
        防粘丝时间。单位：ms，范围：[0 - 10000]
        """
    @time.setter
    def time(self, arg0: int) -> None:
        ...
    @property
    def voltage(self) -> float:
        """
        防粘丝电压。一元化：单位：%，范围：[0 - 50]；分别：单位：V，范围：[0 - 20]
        """
    @voltage.setter
    def voltage(self, arg0: float) -> None:
        ...
class AnticollisionState:
    """
    防撞器状态
    """
    def __init__(self) -> None:
        ...
    @property
    def block(self) -> bool:
        """
        屏蔽开关,开启屏蔽置true，屏蔽时间结束后置false
        """
    @block.setter
    def block(self, arg0: bool) -> None:
        ...
    @property
    def countdown(self) -> int:
        """
        倒计时
        """
    @countdown.setter
    def countdown(self, arg0: int) -> None:
        ...
    @property
    def enable(self) -> bool:
        """
        打开/关闭
        """
    @enable.setter
    def enable(self, arg0: bool) -> None:
        ...
    @property
    def signal(self) -> str:
        """
        DI信号名称
        """
    @signal.setter
    def signal(self, arg0: str) -> None:
        ...
class ArcBreakParam:
    """
    断弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def arc_break_option(self) -> str:
        """
        断弧选项。继续运行："continue_running"，停机并告警："stop_and_alarm"，自动再起弧："auto_arc_reignition"
        """
    @arc_break_option.setter
    def arc_break_option(self, arg0: str) -> None:
        ...
    @property
    def detect_time(self) -> int:
        """
        断弧检测时间。单位：ms，范围：[0 - 10000]
        """
    @detect_time.setter
    def detect_time(self, arg0: int) -> None:
        ...
    @property
    def restart_back_distance(self) -> int:
        """
        再启动回退距离。单位：mm，范围：[0 - 100]
        """
    @restart_back_distance.setter
    def restart_back_distance(self, arg0: int) -> None:
        ...
class ArcData:
    """
    焊接参数
    """
    def __init__(self) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        文件号注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def arc_break_param(self) -> ArcBreakParam:
        """
        断弧和再起弧参数
        """
    @arc_break_param.setter
    def arc_break_param(self, arg0: ArcBreakParam) -> None:
        ...
    @property
    def current(self) -> float:
        """
        起弧电流。单位：电流下为 A，送丝速度下为 mm/s，范围：[0, 2000]
        """
    @current.setter
    def current(self, arg0: float) -> None:
        ...
    @property
    def current_mode(self) -> str:
        """
        电流模式。电流："current"，送丝速度："wire_feed"
        """
    @current_mode.setter
    def current_mode(self, arg0: str) -> None:
        ...
    @property
    def mode(self) -> str:
        """
        焊机工作模式。平特性："flat_characteristic"，低飞溅："low_spatter"，脉冲："pulse"，双脉冲："double_pulse"，直流点焊："dc_spot_welding"，脉冲点焊："pulsed_spot_welding"，大熔深："deep_penetration"
        """
    @mode.setter
    def mode(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def ramp_time(self) -> int:
        """
        渐变时间。单位：ms，范围：[1 - 10000]
        """
    @ramp_time.setter
    def ramp_time(self, arg0: int) -> None:
        ...
    @property
    def voltage(self) -> float:
        """
        起弧电压。单位：分别下为 V，范围：[0, 100]，一元化下为 V 或 %，范围：[-30, 30]
        """
    @voltage.setter
    def voltage(self, arg0: float) -> None:
        ...
    @property
    def voltage_mode(self) -> str:
        """
        电压模式。分别："separate"，一元化："unified"
        """
    @voltage_mode.setter
    def voltage_mode(self, arg0: str) -> None:
        ...
    @property
    def weld_speed(self) -> float:
        """
        焊接速度。单位：mm/s，范围：(0, 10000]
        """
    @weld_speed.setter
    def weld_speed(self, arg0: float) -> None:
        ...
class ArcOffCommand:
    """
    焊接指令 - 收弧，收弧参数默认为default
    """
    def __init__(self, arcOffData: str = 'default') -> None:
        ...
    def getArcOffData(self) -> str:
        ...
    def setArcOffData(self, arcOffData: str, ec: dict) -> None:
        ...
class ArcOffData:
    """
    收弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        文件号注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def anti_wire_stick_param(self) -> AntiWireStickParam:
        """
        防粘丝参数
        """
    @anti_wire_stick_param.setter
    def anti_wire_stick_param(self, arg0: AntiWireStickParam) -> None:
        ...
    @property
    def current(self) -> float:
        """
        起弧电流。单位：电流下为 A，送丝速度下为 mm/s，范围：[0, 2000]
        """
    @current.setter
    def current(self, arg0: float) -> None:
        ...
    @property
    def current_mode(self) -> str:
        """
        电流模式。电流："current"，送丝速度："wire_feed"
        """
    @current_mode.setter
    def current_mode(self, arg0: str) -> None:
        ...
    @property
    def delay_gasoff_time(self) -> int:
        """
        滞后关气时间。单位：ms，范围：[0 - 10000]
        """
    @delay_gasoff_time.setter
    def delay_gasoff_time(self, arg0: int) -> None:
        ...
    @property
    def detect_time(self) -> int:
        """
        收弧检测时间。单位：ms，范围：[0 - 10000]
        """
    @detect_time.setter
    def detect_time(self, arg0: int) -> None:
        ...
    @property
    def hold_time(self) -> int:
        """
        收弧保持时间。单位：ms，范围：[0 - 10000]
        """
    @hold_time.setter
    def hold_time(self, arg0: int) -> None:
        ...
    @property
    def mode(self) -> str:
        """
        焊机工作模式。平特性："flat_characteristic"，低飞溅："low_spatter"，脉冲："pulse"，双脉冲："double_pulse"，直流点焊："dc_spot_welding"，脉冲点焊："pulsed_spot_welding"，大熔深："deep_penetration"
        """
    @mode.setter
    def mode(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def retract_time(self) -> int:
        """
        收弧退丝时间。单位：ms，范围：[0 - 10000]
        """
    @retract_time.setter
    def retract_time(self, arg0: int) -> None:
        ...
    @property
    def voltage(self) -> float:
        """
        起弧电压。单位：分别下为 V，范围：[0, 100]，一元化下为 V 或 %，范围：[-30, 30]
        """
    @voltage.setter
    def voltage(self, arg0: float) -> None:
        ...
    @property
    def voltage_mode(self) -> str:
        """
        电压模式。分别："separate"，一元化："unified"
        """
    @voltage_mode.setter
    def voltage_mode(self, arg0: str) -> None:
        ...
    @property
    def wire_stick_detection_time(self) -> int:
        """
        粘丝检测时间。单位：ms，范围：[0 - 10000]
        """
    @wire_stick_detection_time.setter
    def wire_stick_detection_time(self, arg0: int) -> None:
        ...
class ArcOnCommand:
    """
    焊接指令 - 起弧，起弧参数和焊接参数默认都为default
    """
    def __init__(self, arcOnData: str = 'default', arcData: str = 'default') -> None:
        ...
    def getArcData(self) -> str:
        ...
    def getArcOnData(self) -> str:
        ...
    def setArcData(self, arcData: str, ec: dict) -> None:
        ...
    def setArcOnData(self, arcOnData: str, ec: dict) -> None:
        ...
class ArcOnData:
    """
    起弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def confirm_time(self) -> int:
        """
        起弧确认时间。单位：ms，范围：[0 - 10000]
        """
    @confirm_time.setter
    def confirm_time(self, arg0: int) -> None:
        ...
    @property
    def current(self) -> float:
        """
        起弧电流。单位：电流下为 A，送丝速度下为 mm/s，范围：[0 - 2000]
        """
    @current.setter
    def current(self, arg0: float) -> None:
        ...
    @property
    def current_mode(self) -> str:
        """
        电流模式。电流："current"，送丝速度："wire_feed"
        """
    @current_mode.setter
    def current_mode(self, arg0: str) -> None:
        ...
    @property
    def detect_time(self) -> int:
        """
        起弧检测时间。单位：ms，范围：[0 - 10000]
        """
    @detect_time.setter
    def detect_time(self, arg0: int) -> None:
        ...
    @property
    def hold_time(self) -> int:
        """
        起弧保持时间。单位：ms，范围：[0 - 10000]
        """
    @hold_time.setter
    def hold_time(self, arg0: int) -> None:
        ...
    @property
    def mode(self) -> str:
        """
        焊机工作模式。平特性："flat_characteristic"，低飞溅："low_spatter"，脉冲："pulse"，双脉冲："double_pulse"，直流点焊："dc_spot_welding"，脉冲点焊："pulsed_spot_welding"，大熔深："deep_penetration"
        """
    @mode.setter
    def mode(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def pre_wirefeed_time(self) -> int:
        """
        提前送丝时间。单位：ms，范围：[0, 10000]
        """
    @pre_wirefeed_time.setter
    def pre_wirefeed_time(self, arg0: int) -> None:
        ...
    @property
    def prearc_time(self) -> int:
        """
        提前起弧时间。单位：ms，范围：[0, +∞]
        """
    @prearc_time.setter
    def prearc_time(self, arg0: int) -> None:
        ...
    @property
    def preflow_time(self) -> int:
        """
        提前送气时间。单位：ms，范围：[1 - 10000]
        """
    @preflow_time.setter
    def preflow_time(self, arg0: int) -> None:
        ...
    @property
    def ramp_time(self) -> int:
        """
        渐变时间。单位：ms，范围：[1 - 10000]
        """
    @ramp_time.setter
    def ramp_time(self, arg0: int) -> None:
        ...
    @property
    def re_arcon(self) -> ReArcOnParam:
        """
        再起弧参数
        """
    @re_arcon.setter
    def re_arcon(self, arg0: ReArcOnParam) -> None:
        ...
    @property
    def scratch_arcon(self) -> ScratchArconParam:
        """
        刮擦起弧参数
        """
    @scratch_arcon.setter
    def scratch_arcon(self, arg0: ScratchArconParam) -> None:
        ...
    @property
    def slow_wire_feed_speed(self) -> float:
        """
        慢送丝速度。单位：m/min，范围：[1 - 21]
        """
    @slow_wire_feed_speed.setter
    def slow_wire_feed_speed(self, arg0: float) -> None:
        ...
    @property
    def voltage(self) -> float:
        """
        起弧电压。单位：分别下为 V，范围：[0, 100]，一元化下为 V 或 %，范围：[-30, 30]
        """
    @voltage.setter
    def voltage(self, arg0: float) -> None:
        ...
    @property
    def voltage_mode(self) -> str:
        """
        电压模式。分别："separate"，一元化："unified"
        """
    @voltage_mode.setter
    def voltage_mode(self, arg0: str) -> None:
        ...
class ArcSetOpt:
    """
    焊接参数调整选项
    """
    def __init__(self) -> None:
        ...
    @property
    def arc_data(self) -> str:
        """
        焊接参数名称, 非空时代表需要调整焊接参数
        """
    @arc_data.setter
    def arc_data(self, arg0: str) -> None:
        ...
    @property
    def distance(self) -> float:
        """
        焊接参数在路径上开始发生变化的位置, 单位毫米。注：如果比路径长，则调整发生在路径的端点；对于有转弯区的情形，调整发生在转弯区中点
        """
    @distance.setter
    def distance(self, arg0: float) -> None:
        ...
    @property
    def ref_start(self) -> bool:
        """
        true - 相对下一条路径起点执行焊接参数修改 | false - 相对下一条路径终点
        """
    @ref_start.setter
    def ref_start(self, arg0: bool) -> None:
        ...
class ArcTrackParam:
    """
    电弧跟踪参数设置
    """
    def __init__(self) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        文件号注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def cycle(self) -> int:
        """
        开始周期
        """
    @cycle.setter
    def cycle(self, arg0: int) -> None:
        ...
    @property
    def delay_time(self) -> int:
        """
        延迟时间：电流采样和传输时间的延迟 单位 ms 范围[3,50] 默认 30
        """
    @delay_time.setter
    def delay_time(self, arg0: int) -> None:
        ...
    @property
    def lr_enable(self) -> bool:
        """
        是否开启左右跟踪，默认关闭false
        """
    @lr_enable.setter
    def lr_enable(self, arg0: bool) -> None:
        ...
    @property
    def lr_param(self) -> LrTrackParam:
        """
        左右跟踪参数
        """
    @lr_param.setter
    def lr_param(self, arg0: LrTrackParam) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def ud_enable(self) -> bool:
        """
        是否开启上下跟踪，默认关闭false
        """
    @ud_enable.setter
    def ud_enable(self, arg0: bool) -> None:
        ...
    @property
    def ud_param(self) -> UdTrackParam:
        """
        上下跟踪参数
        """
    @ud_param.setter
    def ud_param(self, arg0: UdTrackParam) -> None:
        ...
class ArcWeldRunningParam:
    """
    运行参数
    """
    def __init__(self) -> None:
        ...
    @property
    def gas_detect_time(self) -> int:
        """
        气体检测时间。单位：s，范围：[1, 30]
        """
    @gas_detect_time.setter
    def gas_detect_time(self, arg0: int) -> None:
        ...
    @property
    def test_run_speed(self) -> float:
        """
        空运行笛卡尔速度。单位：mm/s，范围：[1, 250]
        """
    @test_run_speed.setter
    def test_run_speed(self, arg0: float) -> None:
        ...
    @property
    def wire_feed_speed(self) -> float:
        """
        手动点动送/退丝速度。单位：m/min。跟焊机本身有关，范围：(0, +∞)
        """
    @wire_feed_speed.setter
    def wire_feed_speed(self, arg0: float) -> None:
        ...
class ArcWelding:
    def __init__(self, arg0: ...) -> None:
        ...
    def calcIntersection(self, points: list[xCoreSDK_python.CartesianPosition], ec: dict) -> xCoreSDK_python.CartesianPosition:
        """
        激光寻位 - 四点计算交点。只计算位置，姿态取points第一点的姿态
        
        Args:
            points (list[CartesianPosition]): 寻到的4个点位，前两个是组成直线1，后两个组成直线2
            ec (dict): 错误码
        
        Returns:
            CartesianPosition: 计算出的交点，无错误码时有效
        """
    def calculateCurrentCurve(self, data: CharacteristicCurveData, ec: dict) -> CharacteristicCurveData:
        """
        计算电流特性曲线参数，仅计算不保存
        
        Args:
            data (CharacteristicCurveData): 电流特性曲线参数对象，只需设置name和points
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            CharacteristicCurveData: 计算后的电流特性曲线参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def calculateVoltageCurve(self, data: CharacteristicCurveData, ec: dict) -> CharacteristicCurveData:
        """
        计算电压特性曲线参数，仅计算不保存
        
        Args:
            data (CharacteristicCurveData): 电压特性曲线参数对象，只需设置name和points
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            CharacteristicCurveData: 计算后的电压特性曲线参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def calibrateEnd(self, loss: list, ec: dict) -> HandeyeData:
        """
        手眼标定结束，计算标定结果
        
        Args:
            loss (list[float]): 自校验误差[max,min,mean]
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            HandeyeData: 手眼标定结果
        """
    def calibratePoint(self, id: int, ec: dict) -> CalibrationResult:
        """
        手眼标定添加点位
        
        Args:
            id (int): 点位编号.0:尖端采集点，1-6:标定点
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            CalibrationResult: 点位结果
        """
    def cancelAutoGoBackOnce(self, ec: dict) -> None:
        """
        焊接参数 - 再启动回退距离不为零时，实焊模式下再启动都会回退一段再起弧焊接。
        暂停状态下调用该接口，可以暂时关闭回退一次，从暂停点开始运动
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def closeLaserTrack(self, device_name: str, ec: dict) -> None:
        """
        关闭焊缝跟踪器，停止获取激光器焊缝数据
        
        Args:
            device_name (str): 激光传感器设备名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def connLaserSensorDev(self, device_name: str, ec: dict) -> None:
        """
        连接激光传感器设备
        
        Args:
            device_name (str): 激光传感器设备名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def connectToWelder(self, ec: dict) -> None:
        """
        连接焊机，启用弧焊功能
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def detectGas(self, time: float, enable: bool, ec: dict) -> None:
        """
        控制检气操作
        
        Args:
            time (float): 检气时间，单位：秒，范围：大于0.1
            enable (bool): 是否启用检气，True表示启用，False表示停止（默认True）
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            仅在enable为True时，time参数生效
        """
    def disconnLaserSensorDev(self, device_name: str, ec: dict) -> None:
        """
        断开连接激光传感器设备
        
        Args:
            device_name (str): 激光传感器设备名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def disconnectFromWelder(self, ec: dict) -> None:
        """
        断开焊机连接，关闭弧焊功能
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def enableArcData(self, arcData: ArcData, ec: dict) -> None:
        """
        生效焊接参数
        
        Note:
            在未运行时将焊接参数发送给焊机，观察焊机面板显示，用于检查通讯是否建立，设置是否准确，不保存
        
        Args:
            arcData (ArcData): 焊接参数
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def executeLaserSearch(self, cmd: LaserSearchCommand, isMove: bool, timeout: datetime.timedelta, ec: dict) -> tuple[bool, xCoreSDK_python.CartesianPosition]:
        """
        激光寻位，阻塞等待运动结束
        
        Args:
            cmd (LaserSearchCommand): 激光寻位指令
            isMove (bool): 是否立即开始运动。False：只添加寻位指令，需要额外使用moveStart()执行；True：添加寻位指令并执行
            timeout (float): 超时时间，单位为秒。0：不等待寻位结果直接退出，返回默认值；>0：等待寻位结果，超时返回默认值
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            tuple[bool, CartesianPosition]: 是否寻到，寻到的位姿。寻到的位姿是基于工具工件坐标系的
        
        Note:
            如果设置了超时时间，该函数会阻塞直到超时或者寻位结束
        """
    def feedBackWire(self, time: float, enable: bool, ec: dict) -> None:
        """
        控制退丝操作
        
        Args:
            time (float): 退丝时间，单位：秒，范围：大于0.1
            enable (bool): 是否启用退丝，True表示启用，False表示停止（默认True）
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            仅在enable为True时，time参数生效
        """
    def feedOnWire(self, time: float, enable: bool, ec: dict) -> None:
        """
        控制送丝操作
        
        Args:
            time (float): 送丝时间，单位：秒，范围：大于0.1
            enable (bool): 是否启用送丝，True表示启用，False表示停止（默认True）
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            仅在enable为True时，time参数生效
        """
    def getAnticollisionState(self, ec: dict) -> AnticollisionState:
        """
        获取防碰撞传感器的设置或状态
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            AnticollisionState: 防碰撞设置或状态对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getArcData(self, arcDataName: str, ec: dict) -> ArcData:
        """
        获取焊接参数配置
        
        Args:
            arcDataName (str): 焊接参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            ArcData: 焊接参数对象，在ec["ec"]为0时有效，否则返回默认值
        """
    def getArcOffData(self, arcoffDataName: str, ec: dict) -> ArcOffData:
        """
        获取收弧参数配置
        
        Args:
            arcoffDataName (str): 收弧参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            ArcOffData: 收弧参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getArcOnData(self, arconDataName: str, ec: dict) -> ArcOnData:
        """
        获取起弧参数配置
        
        Args:
            arcon_data_name (str): 起弧参数名称，用于指定需要获取的起弧参数配置集
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            ArcOnData: 起弧参数，在错误码为0时有效，如果错误码不为0，返回默认值
        """
    def getArcTrackParam(self, name: str, ec: dict) -> ArcTrackParam:
        """
        获取电弧跟踪参数设置
        
        Args:
            name (str): 电弧跟踪参数文件号
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            ArcTrackParam: 电弧跟踪参数，在ec['ec']为0时有效，否则返回默认值
        """
    def getCurrentCharacteristicCurveData(self, name: str, ec: dict) -> CharacteristicCurveData:
        """
        获取电流特性曲线参数配置
        
        Args:
            name (str): 文件名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            CharacteristicCurveData: 电流特性曲线参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getHandeyeData(self, name: str, ec: dict) -> HandeyeData:
        """
        获取指定名称的手眼标定结果
        
        Args:
            name (str): 手眼标定结果文件号
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            HandeyeData: 手眼标定结果对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getIOSetting(self, ec: dict) -> IOSetting:
        """
        获取IO设置
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            IOSetting: IO设置对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getLaserSearchData(self, laserSearchDataName: str, ec: dict) -> LaserSearchData:
        """
        获取激光寻位参数配置
        
        Args:
            laserSearchDataName (str): 激光寻位参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            LaserSearchData: 激光寻位参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getLaserSensorCfg(self, name: str, ec: dict) -> LaserSensorCfg:
        """
        获取指定名称的激光传感器配置参数
        
        Args:
            name (str): 激光传感器名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            LaserSensorCfg: 激光传感器配置参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getLaserTrackData(self, laserTrackDataName: str, ec: dict) -> LaserTrackData:
        """
        获取激光跟踪参数配置
        
        Args:
            laserTrackDataName (str): 激光跟踪参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            LaserTrackData: 激光跟踪参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getRunningParam(self, ec: dict) -> ArcWeldRunningParam:
        """
        读取当前焊接运行参数
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            ArcWeldRunningParam: 焊接运行参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getSegData(self, segDataName: str, ec: dict) -> SegData:
        """
        获取间断焊参数配置
        
        Args:
            segDataName (str): 间断焊参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            SegData: 间断焊参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getVoltageCharacteristicCurveData(self, name: str, ec: dict) -> CharacteristicCurveData:
        """
        获取电压特性曲线参数配置
        
        Args:
            name (str): 文件名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            CharacteristicCurveData: 电压特性曲线参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getWeaveAdaptiveData(self, ec: dict) -> WeaveAdaptiveData:
        """
        获取摆焊-自适应参数
        
        Args:
            ec (dict): 错误码
        
        Returns:
            WeaveAdaptiveData: 摆焊-自适应参数，在错误码为0时有效，如果错误码不为0，返回默认值
        """
    def getWeaveData(self, weaveDataName: str, ec: dict) -> WeaveData:
        """
        获取摆焊参数配置
        
        Args:
            weaveDataName (str): 摆焊参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            WeaveData: 摆焊参数对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getWeldMode(self, ec: dict) -> WeldMode:
        """
        获取当前焊接模式
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            WeldMode: 焊接模式对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getWelderSetting(self, ec: dict) -> WelderSetting:
        """
        获取焊机设置
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            WelderSetting: 焊机设置对象，在ec['ec']为0时有效，否则返回默认值
        """
    def getWelderStatus(self, ec: dict) -> WelderStatus:
        """
        获取焊机状态
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            WelderStatus: 焊机状态对象，在ec['ec']为0时有效，否则返回默认值
        """
    def isEniHaveWeld(self, ec: dict) -> bool:
        """
        检查是否连接物理焊机（仅适用于EtherCAT焊机）
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Returns:
            bool: 是否连接物理焊机，在ec['ec']为0时有效，否则返回False
        """
    def openLaserTrack(self, device_name: str, ec: dict) -> None:
        """
        打开焊缝跟踪器，开始获取激光器焊缝数据
        
        Args:
            device_name (str): 激光传感器设备名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcData(self, arcDataName: str, ec: dict) -> None:
        """
        删除指定名称的焊接参数
        
        Args:
            arcDataName (str): 要删除的焊接参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcData(self, arcDataNames: list[str], ec: dict) -> None:
        """
        批量删除焊接参数
        
        Args:
            arcDataNames (list[str]): 要删除的焊接参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcOffData(self, arcoffDataName: str, ec: dict) -> None:
        """
        删除指定名称的收弧参数
        
        Args:
            arcoffDataName (str): 要删除的收弧参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcOffData(self, arcoffDataNames: list[str], ec: dict) -> None:
        """
        批量删除收弧参数
        
        Args:
            arcoffDataNames (list[str]): 要删除的收弧参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcOnData(self, arconDataName: str, ec: dict) -> None:
        """
        删除指定名称的起弧参数
        
        Args:
            arconDataName (str): 要删除的起弧参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcOnData(self, arconDataNames: list[str], ec: dict) -> None:
        """
        批量删除起弧参数
        
        Args:
            arconDataNames (list[str]): 要删除的起弧参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcTrackParam(self, name: str, ec: dict) -> None:
        """
        删除电弧跟踪参数
        
        Args:
            name (str): 电弧跟踪参数文件号
            ec (dict): 错误码，包含错误码和错误描述信息
        """
    @typing.overload
    def removeArcTrackParam(self, names: list[str], ec: dict) -> None:
        """
        删除多个电弧跟踪参数
        
        Args:
            names (list[str]): 电弧跟踪参数文件号列表
            ec (dict): 错误码，包含错误码和错误描述信息
        """
    @typing.overload
    def removeHandeyeData(self, name: str, ec: dict) -> None:
        """
        删除指定名称的手眼标定结果
        
        Args:
            name (str): 手眼标定文件号
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeHandeyeData(self, names: list[str], ec: dict) -> None:
        """
        批量删除手眼标定结果
        
        Args:
            names (list[str]): 手眼标定文件号列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserSearchData(self, laserSearchDataName: str, ec: dict) -> None:
        """
        删除指定名称的激光寻位参数
        
        Args:
            laserSearchDataName (str): 要删除的激光寻位参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserSearchData(self, laserSearchDataNames: list[str], ec: dict) -> None:
        """
        批量删除激光寻位参数
        
        Args:
            laserSearchDataNames (list[str]): 要删除的激光寻位参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserSensorCfg(self, name: str, ec: dict) -> None:
        """
        删除指定名称的激光传感器配置参数
        
        Args:
            device_name (str): 激光传感器设备名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserSensorCfg(self, names: list[str], ec: dict) -> None:
        """
        批量删除激光传感器配置参数
        
        Args:
            device_names (list[str]): 激光传感器设备名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserTrackData(self, laserTrackDataName: str, ec: dict) -> None:
        """
        删除指定名称的激光跟踪参数
        
        Args:
            laserTrackDataName (str): 要删除的激光跟踪参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeLaserTrackData(self, laserTrackDataNames: list[str], ec: dict) -> None:
        """
        批量删除激光跟踪参数
        
        Args:
            laserTrackDataNames (list[str]): 要删除的激光跟踪参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeSegData(self, segDataName: str, ec: dict) -> None:
        """
        删除指定名称的间断焊参数
        
        Args:
            segDataName (str): 要删除的间断焊参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeSegData(self, segDataNames: list[str], ec: dict) -> None:
        """
        批量删除间断焊参数
        
        Args:
            segDataNames (list[str]): 要删除的间断焊参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeWeaveData(self, weaveDataName: str, ec: dict) -> None:
        """
        删除指定名称的摆焊参数
        
        Args:
            weaveDataName (str): 要删除的摆焊参数名称
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def removeWeaveData(self, weaveDataNames: list[str], ec: dict) -> None:
        """
        批量删除摆焊参数
        
        Args:
            weaveDataNames (list[str]): 要删除的摆焊参数名称列表
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def saveCurrentAndVoltage(self, current: float, voltage: float, ec: dict) -> None:
        """
        在线保存电流和电压
        
        Args:
            current (float): 电流或送丝速度，单位：A 或 mm/s，对应当前焊接的电流模式
            voltage (float): 电压，单位：V 或 %，对应当前焊接的电压模式
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            仅在焊接状态下生效
        """
    def setAnticollision(self, signal: str, enable: bool, block: bool, countdown: int, ec: dict) -> None:
        """
        设置防碰撞传感器
        
        Args:
            signal (str): DI信号名称
            enable (bool): 打开/关闭防碰撞传感器
            block (bool): 屏蔽开关
            countdown (int): 倒计时，倒计时结束后打开防撞器
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            错误码说明：
                -260 - 缺少必要参数
                -14510 - 绑定系统输入失败（DI信号不存在或已绑定为系统输入）
        """
    def setArcData(self, arcData: ArcData, ec: dict) -> None:
        """
        设置焊接参数配置
        
        Args:
            arcData (ArcData): 焊接参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setArcOffData(self, arcoffData: ArcOffData, ec: dict) -> None:
        """
        设置收弧参数配置
        
        Args:
            arcoffData (ArcOffData): 收弧参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setArcOnData(self, arconData: ArcOnData, ec: dict) -> None:
        """
        设置起弧参数配置
        
        Args:
            arconData (ArcOnData): 起弧参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setArcTrackParam(self, param: ArcTrackParam, ec: dict) -> None:
        """
        设置电弧跟踪参数
        
        Args:
            param (ArcTrackParam): 电弧跟踪参数
            ec (dict): 错误码，包含错误码和错误描述信息
        """
    def setCurrentAndVoltage(self, current: float, voltage: float, ec: dict) -> None:
        """
        在线设置电流和电压
        
        Args:
            current (float): 电流或送丝速度，单位：A 或 mm/s，对应当前焊接的电流模式
            voltage (float): 电压，单位：V 或 %，对应当前焊接的电压模式
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            仅在焊接状态下生效
        """
    def setCurrentCharacteristicCurveData(self, data: CharacteristicCurveData, ec: dict) -> None:
        """
        设置电流特性曲线参数配置，并执行计算和保存
        
        Args:
            data (CharacteristicCurveData): 电流特性曲线参数对象，只需设置name和points
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setHandeyeData(self, handeyeData: HandeyeData, ec: dict) -> None:
        """
        添加设置手眼标定结果参数
        
        Args:
            handeyedata (HandeyeData): 手眼标定结果对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setIOSetting(self, ioSetting: IOSetting, ec: dict) -> None:
        """
        设置IO设置，必须在未启用焊接时才能设置
        
        Args:
            ioSetting (IOSetting): IO设置对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setIsEniHaveWeld(self, isHaveWeld: bool, ec: dict) -> None:
        """
        设置是否连接物理焊机（仅适用于EtherCAT焊机）
        
        Args:
            isEniHaveWeld (bool): 是否连接物理焊机
            ec (dict): 错误码字典，包含错误码和错误描述信息
        
        Note:
            不成功的原因通常为缺少对应的ENI文件，请导入相应的ENI文件
        """
    def setLaserSearchData(self, laserSearchData: LaserSearchData, ec: dict) -> None:
        """
        设置激光寻位参数配置
        
        Args:
            laserSearchData (LaserSearchData): 激光寻位参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setLaserSensorCfg(self, cfg: LaserSensorCfg, ec: dict) -> None:
        """
        添加设置激光传感器配置参数
        
        Args:
            cfg (LaserSensorCfg): 激光传感器基础配置数据
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setLaserTrackData(self, laserTrackData: LaserTrackData, ec: dict) -> None:
        """
        设置激光跟踪参数配置
        
        Args:
            laserTrackData (LaserTrackData): 激光跟踪参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setRunningParam(self, runningParam: ArcWeldRunningParam, ec: dict) -> None:
        """
        设置焊接运行参数
        
        Args:
            data (ArcWeldRunningParam): 焊接运行参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setSegData(self, segData: SegData, ec: dict) -> None:
        """
        设置间断焊参数配置
        
        Args:
            segData (SegData): 间断焊参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setVoltageCharacteristicCurveData(self, data: CharacteristicCurveData, ec: dict) -> None:
        """
        设置电压特性曲线参数配置，并执行计算和保存
        
        Args:
            data (CharacteristicCurveData): 电压特性曲线参数对象，只需设置name和points
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setWeaveAdaptiveData(self, weaveAdaptiveData: WeaveAdaptiveData, ec: dict) -> None:
        """
        设置摆焊-自适应参数
        
        Args:
            weaveAdaptiveData (WeaveAdaptiveData): 摆焊-自适应参数
            ec (dict): 错误码
        """
    def setWeaveData(self, weaveData: WeaveData, ec: dict) -> None:
        """
        设置摆焊参数配置
        
        Args:
            weaveData (WeaveData): 摆焊参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def setWeldMode(self, weldMode: WeldMode, ec: dict) -> None:
        """
        设置焊接模式
        
        Args:
            weldMode (WeldMode): 焊接模式对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def setWelder(self, protocol: str, mfr: str, type: str, current: int, ec: dict) -> None:
        """
        设置焊机参数（通过协议、厂商、类型、电流类型）
        
        Args:
            protocol (str): 协议，例如 "ethercat"
            mfr (str): 厂商，例如 "aotai"
            type (str): 类型，例如 "RL/RPL", "RP/RPH"
            current (int): 电流类型，例如 350, 500, 630, 800
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    @typing.overload
    def setWelder(self, welderSetting: WelderSetting, ec: dict) -> None:
        """
        设置焊机参数（通过焊机设置参数对象）
        
        Args:
            welderSetting (ArcWelding.WelderSetting): 焊机设置参数对象
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def startHandeyeCalibration(self, name: str, type: int, ec: dict) -> None:
        """
        开始手眼标定，需要已经连接激光传感器
        
        Args:
            name (str): 手眼标定文件号
            type (int): 标定点数，目前只能是6
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
    def startWelding(self, current: float, voltage: float, voltage_mode: str, ec: dict) -> None:
        """
        开始铆焊操作
        
        Args:
            current (float): 电流，单位：A，范围[1,300]
            voltage (float): 电压，单位：V 或 %，范围[-30,30]
            voltage_mode (str): 电压模式，"separate"-分别，"unified"-一元化
            ec (dict): 错误码字典，包含错误码和错误描述信息
            
        Note:
            工作模式为直流，电流模式为电流，电压模式默认为一元化
        """
    def stopWelding(self, ec: dict) -> None:
        """
        停止铆焊操作
        
        Args:
            ec (dict): 错误码字典，包含错误码和错误描述信息
        """
class CalibrationResult:
    """
    自动标定点位结果
    """
    def __init__(self) -> None:
        ...
    @property
    def id(self) -> int:
        """
        点位序号
        """
    @id.setter
    def id(self, arg0: int) -> None:
        ...
    @property
    def p_laser(self) -> list[float]:
        """
        相机坐标
        """
    @p_laser.setter
    def p_laser(self, arg0: list[float]) -> None:
        ...
    @property
    def p_robot(self) -> list[float]:
        """
        机器人坐标
        """
    @p_robot.setter
    def p_robot(self, arg0: list[float]) -> None:
        ...
class CharacteristicCurveData:
    """
    特性曲线参数
    """
    def __init__(self) -> None:
        ...
    @property
    def intercept(self) -> float:
        """
        截距
        """
    @intercept.setter
    def intercept(self, arg0: float) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def points(self) -> list[typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(2)]]:
        """
        点位数组
        """
    @points.setter
    def points(self, arg0: list[typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(2)]]) -> None:
        ...
    @property
    def slope(self) -> float:
        """
        斜率
        """
    @slope.setter
    def slope(self, arg0: float) -> None:
        ...
class ElevationAngle:
    """
    仰角
    """
    def __init__(self) -> None:
        ...
    @property
    def left(self) -> float:
        """
        左仰角。单位：°，范围：[-90, 90]
        """
    @left.setter
    def left(self, arg0: float) -> None:
        ...
    @property
    def right(self) -> float:
        """
        右仰角。单位：°，范围：[-90, 90]
        """
    @right.setter
    def right(self, arg0: float) -> None:
        ...
class FeedBackWireCommand:
    """
    焊接指令 - 退丝，时间单位为秒，退丝速度默认为1.0 m/min，退丝默认生效true
    """
    def __init__(self, time: float, speed: float = 1.0, isReverse: int = True) -> None:
        ...
    def getFeedBackWireData(self, time: xCoreSDK_python.PyTypeDouble, speed: xCoreSDK_python.PyTypeDouble, isReverse: xCoreSDK_python.PyTypeBool) -> None:
        ...
    def setFeedBackWireData(self, time: float, speed: float, isReverse: bool, ec: dict) -> None:
        ...
class FeedOnWireCommand:
    """
    焊接指令 - 送丝，时间单位为秒，送丝速度默认为1.0 m/min，送丝默认生效true
    """
    def __init__(self, time: float, speed: float = 1.0, isFeed: int = True) -> None:
        ...
    def getFeedOnWireData(self, time: xCoreSDK_python.PyTypeDouble, speed: xCoreSDK_python.PyTypeDouble, isFeed: xCoreSDK_python.PyTypeBool) -> None:
        ...
    def setFeedOnWireData(self, time: float, speed: float, isFeed: bool, ec: dict) -> None:
        ...
class HandeyeData:
    """
    手眼标定结果
    """
    def __init__(self) -> None:
        ...
    @property
    def mode(self) -> bool:
        """
        标定结果形式 true:xyz_abc false:RT矩阵
        """
    @mode.setter
    def mode(self, arg0: bool) -> None:
        ...
    @property
    def name(self) -> str:
        """
        手眼标定结果文件号
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def rotMatrix(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(9)]:
        """
        旋转矩阵的行优先向量
        """
    @rotMatrix.setter
    def rotMatrix(self, arg0: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(9)]) -> None:
        ...
    @property
    def transVector(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)]:
        """
        平移向量
        """
    @transVector.setter
    def transVector(self, arg0: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)]) -> None:
        ...
    @property
    def xyz_abc(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)]:
        """
        笛卡尔空间位姿形式 单位：mm rad
        """
    @xyz_abc.setter
    def xyz_abc(self, arg0: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)]) -> None:
        ...
class IOData:
    """
    IO端口
    """
    def __init__(self) -> None:
        ...
    @property
    def bias(self) -> int:
        """
        偏差。类型为寄存器的时候有效
        """
    @bias.setter
    def bias(self, arg0: int) -> None:
        ...
    @property
    def enable(self) -> bool:
        """
        是否启用
        """
    @enable.setter
    def enable(self, arg0: bool) -> None:
        ...
    @property
    def name(self) -> str:
        """
        名称。DI0，DO1，AO2，AI3...或寄存器名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def type(self) -> int:
        """
        类型。0：未设置；1：DI；2：DO；3：AO；4：AI；5：寄存器
        """
    @type.setter
    def type(self, arg0: int) -> None:
        ...
class IOSetting:
    """
    IO设置
    """
    def __init__(self) -> None:
        ...
    @property
    def arc_on(self) -> IOData:
        """
        起弧端口
        """
    @arc_on.setter
    def arc_on(self, arg0: IOData) -> None:
        ...
    @property
    def arc_on_success(self) -> IOData:
        """
        引弧成功判断
        """
    @arc_on_success.setter
    def arc_on_success(self, arg0: IOData) -> None:
        ...
    @property
    def current_get(self) -> IOData:
        """
        电流获取
        """
    @current_get.setter
    def current_get(self, arg0: IOData) -> None:
        ...
    @property
    def current_set(self) -> IOData:
        """
        电流指定
        """
    @current_set.setter
    def current_set(self, arg0: IOData) -> None:
        ...
    @property
    def error(self) -> IOData:
        """
        报警
        """
    @error.setter
    def error(self, arg0: IOData) -> None:
        ...
    @property
    def gas_test(self) -> IOData:
        """
        气体检测
        """
    @gas_test.setter
    def gas_test(self, arg0: IOData) -> None:
        ...
    @property
    def positioning_enable(self) -> IOData:
        """
        寻位使能信号
        """
    @positioning_enable.setter
    def positioning_enable(self, arg0: IOData) -> None:
        ...
    @property
    def positioning_feedback(self) -> IOData:
        """
        寻位反馈信号
        """
    @positioning_feedback.setter
    def positioning_feedback(self, arg0: IOData) -> None:
        ...
    @property
    def robot_ready(self) -> IOData:
        """
        机器人准备好
        """
    @robot_ready.setter
    def robot_ready(self, arg0: IOData) -> None:
        ...
    @property
    def voltage_get(self) -> IOData:
        """
        电压获取
        """
    @voltage_get.setter
    def voltage_get(self, arg0: IOData) -> None:
        ...
    @property
    def voltage_set(self) -> IOData:
        """
        电压/弧长校正给定
        """
    @voltage_set.setter
    def voltage_set(self, arg0: IOData) -> None:
        ...
    @property
    def wire_feed(self) -> IOData:
        """
        送丝
        """
    @wire_feed.setter
    def wire_feed(self, arg0: IOData) -> None:
        ...
    @property
    def wire_feed_back(self) -> IOData:
        """
        回抽丝
        """
    @wire_feed_back.setter
    def wire_feed_back(self, arg0: IOData) -> None:
        ...
class LaserSearchCommand:
    """
    焊接指令 - 激光寻位
    """
    endPoint: xCoreSDK_python.CartesianPosition
    laserHandEyeData: str
    laserSearchData: str
    speed: int
    zone: int
    def __init__(self, laserHandEyeData: str, laserSearchData: str, endPoint: xCoreSDK_python.CartesianPosition, speed: int = -1, zone: int = -1) -> None:
        ...
class LaserSearchData:
    """
    激光寻位参数
    """
    def __init__(self) -> None:
        ...
    @property
    def job_number(self) -> int:
        """
        激光寻位工艺编号。范围：[0,63]
        """
    @job_number.setter
    def job_number(self, arg0: int) -> None:
        ...
    @property
    def joint_type(self) -> str:
        """
        焊缝类型。角接："corner_joint"，搭接："lap_joint"，对接："butt_joint"
        """
    @joint_type.setter
    def joint_type(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def search_mode(self) -> str:
        """
        寻位模式。连续："continuous" | 静态寻位 "static" | 步进："step"。（当前支持连续和静态寻位）
        """
    @search_mode.setter
    def search_mode(self, arg0: str) -> None:
        ...
    @property
    def search_type(self) -> str:
        """
        寻位类型。点寻位："point"
        """
    @search_type.setter
    def search_type(self, arg0: str) -> None:
        ...
    @property
    def step_length(self) -> float:
        """
        步进距离。单位：mm
        """
    @step_length.setter
    def step_length(self, arg0: float) -> None:
        ...
class LaserSensorCfg:
    """
    激光传感器配置信息设置
    """
    def __init__(self) -> None:
        ...
    @property
    def communication_cycle(self) -> int:
        """
        控制器和激光跟踪器通信周期 单位：ms 范围：1-10000
        """
    @communication_cycle.setter
    def communication_cycle(self, arg0: int) -> None:
        ...
    @property
    def ip(self) -> str:
        """
        IP地址
        """
    @ip.setter
    def ip(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        设备名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def overtime(self) -> int:
        """
        连接超时时间设置 单位：ms 范围：1-100000
        """
    @overtime.setter
    def overtime(self, arg0: int) -> None:
        ...
    @property
    def port(self) -> int:
        """
        端口号
        """
    @port.setter
    def port(self, arg0: int) -> None:
        ...
    @property
    def type(self) -> LaserSensorType:
        """
        激光器厂家类别（目前支持：创想CRNT、明图SMART_IMAGE、英莱INTELLIGENT）
        """
    @type.setter
    def type(self, arg0: LaserSensorType) -> None:
        ...
class LaserSensorType:
    """
    激光传感器品牌选择
    
    Members:
    
      CRNT : 创想激光器
    
      SMART_IMAGE : 明图激光器
    
      INTELLIGENT : 英莱传感器
    """
    CRNT: typing.ClassVar[LaserSensorType]  # value = <LaserSensorType.CRNT: 0>
    INTELLIGENT: typing.ClassVar[LaserSensorType]  # value = <LaserSensorType.INTELLIGENT: 2>
    SMART_IMAGE: typing.ClassVar[LaserSensorType]  # value = <LaserSensorType.SMART_IMAGE: 1>
    __members__: typing.ClassVar[dict[str, LaserSensorType]]  # value = {'CRNT': <LaserSensorType.CRNT: 0>, 'SMART_IMAGE': <LaserSensorType.SMART_IMAGE: 1>, 'INTELLIGENT': <LaserSensorType.INTELLIGENT: 2>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class LaserTrackData:
    """
    激光跟踪参数
    """
    def __init__(self) -> None:
        ...
    @property
    def job_number(self) -> int:
        """
        跟踪器工艺编号。范围：[0,63]
        """
    @job_number.setter
    def job_number(self, arg0: int) -> None:
        ...
    @property
    def max_invalid_length(self) -> float:
        """
        最大无效焊缝停止距离, 单位mm, 范围(0, 50]
        """
    @max_invalid_length.setter
    def max_invalid_length(self, arg0: float) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def y_comp(self) -> bool:
        """
        Y方向补偿开关
        """
    @y_comp.setter
    def y_comp(self, arg0: bool) -> None:
        ...
    @property
    def z_comp(self) -> bool:
        """
        Z方向补偿开关
        """
    @z_comp.setter
    def z_comp(self, arg0: bool) -> None:
        ...
class LaserTrackOffCommand:
    """
    焊接指令 - 停止激光跟踪
    """
    def __init__(self) -> None:
        ...
class LaserTrackOnCommand:
    """
    焊接指令 - 开始激光跟踪
    """
    def __init__(self, handEyeData: str = 'default', laserTrackData: str = 'default') -> None:
        ...
    def getHandEyeData(self) -> str:
        ...
    def getLaserTrackData(self) -> str:
        ...
    def setHandEyeData(self, handEyeData: str, ec: dict) -> None:
        ...
    def setLaserTrackData(self, laserTrackData: str, ec: dict) -> None:
        ...
class LrTrackParam:
    """
    电弧跟踪左右跟踪参数
    """
    def __init__(self) -> None:
        ...
    @property
    def curr_bias_offset(self) -> float:
        """
        电流偏差系数：补偿正常摆动时左右电流固有偏差 范围[0,10] 默认 5
        """
    @curr_bias_offset.setter
    def curr_bias_offset(self, arg0: float) -> None:
        ...
    @property
    def max_compensation(self) -> float:
        """
        最大补偿量：单次补偿最大值 单位 mm 范围[1,10] 默认 0.4
        """
    @max_compensation.setter
    def max_compensation(self, arg0: float) -> None:
        ...
    @property
    def min_compensation(self) -> float:
        """
        最小补偿量：单次补偿最小值，控制量小于该值不予补偿 单位 mm 范围[1,10] 默认 0.01
        """
    @min_compensation.setter
    def min_compensation(self, arg0: float) -> None:
        ...
    @property
    def pid(self) -> float:
        """
        比例增益：调节左右跟踪的快慢 范围[0,10] 默认 5
        """
    @pid.setter
    def pid(self, arg0: float) -> None:
        ...
class ReArcOnParam:
    """
    再起弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def current_step(self) -> float:
        """
        再起弧电流增量。单位：A，范围：[0 - 50]
        """
    @current_step.setter
    def current_step(self, arg0: float) -> None:
        ...
    @property
    def enable(self) -> bool:
        """
        是否再起弧
        """
    @enable.setter
    def enable(self, arg0: bool) -> None:
        ...
    @property
    def retry_time(self) -> int:
        """
        起弧次数。范围：[1 - 20]
        """
    @retry_time.setter
    def retry_time(self, arg0: int) -> None:
        ...
    @property
    def voltage_step(self) -> float:
        """
        再起弧电压增量。单位：V 或 %，一元化下为 %，范围：[0 - 10] V 或 [0 - 10] %
        """
    @voltage_step.setter
    def voltage_step(self, arg0: float) -> None:
        ...
    @property
    def wire_retract_delay_time(self) -> int:
        """
        再起弧退丝等待时间。单位：ms，范围：[0 - 10000]
        """
    @wire_retract_delay_time.setter
    def wire_retract_delay_time(self, arg0: int) -> None:
        ...
    @property
    def wire_retract_time(self) -> int:
        """
        再起弧退丝时间。单位：ms，范围：[0 - 10000]
        """
    @wire_retract_time.setter
    def wire_retract_time(self, arg0: int) -> None:
        ...
class ScratchArconParam:
    """
    刮擦起弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def back_speed(self) -> int:
        """
        返回速度。单位：mm/s，范围：(0 - 7000]
        """
    @back_speed.setter
    def back_speed(self, arg0: int) -> None:
        ...
    @property
    def distance(self) -> int:
        """
        刮擦距离。单位：mm，范围：[0 - 500]
        """
    @distance.setter
    def distance(self, arg0: int) -> None:
        ...
    @property
    def enable(self) -> bool:
        """
        是否刮擦起弧
        """
    @enable.setter
    def enable(self, arg0: bool) -> None:
        ...
    @property
    def step(self) -> int:
        """
        刮擦步长。单位：mm，范围：[0 - 500]
        """
    @step.setter
    def step(self, arg0: int) -> None:
        ...
class SegData:
    """
    间断焊参数
    """
    def __init__(self) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        文件号注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def non_welded_distance(self) -> float:
        """
        非焊接段长度。单位：mm，范围：大于0.1
        """
    @non_welded_distance.setter
    def non_welded_distance(self, arg0: float) -> None:
        ...
    @property
    def non_welded_speed(self) -> str:
        """
        非焊接段速度，xCore预定义的v5、v10...
        """
    @non_welded_speed.setter
    def non_welded_speed(self, arg0: str) -> None:
        ...
    @property
    def seg_type(self) -> str:
        """
        间断焊类型。普通："normal"
        """
    @seg_type.setter
    def seg_type(self, arg0: str) -> None:
        ...
    @property
    def welded_distance(self) -> float:
        """
        焊接段长度。单位：mm，范围：大于0.1
        """
    @welded_distance.setter
    def welded_distance(self, arg0: float) -> None:
        ...
class SegOffCommand:
    """
    焊接指令 - 停止间断焊
    """
    def __init__(self) -> None:
        ...
class SegOnCommand:
    """
    焊接指令 - 开始间断焊
    """
    def __init__(self, segData: str = 'default') -> None:
        ...
    @property
    def segData(self) -> str:
        """
        间断焊参数名
        """
    @segData.setter
    def segData(self, arg0: str) -> None:
        ...
class UdTrackParam:
    """
    电弧跟踪上下跟踪参数
    """
    def __init__(self) -> None:
        ...
    @property
    def base_current(self) -> float:
        """
        基准电流值：当“ 基准电流方法” 为“ 定值” 时才需要设置该参数 单位:A 范围[0, 1000] 默认 0
        """
    @base_current.setter
    def base_current(self, arg0: float) -> None:
        ...
    @property
    def curr_bias_offset(self) -> float:
        """
        电流偏差系数：补偿正常摆动时上下电流固有偏差 范围[0,10] 默认 5
        """
    @curr_bias_offset.setter
    def curr_bias_offset(self, arg0: float) -> None:
        ...
    @property
    def max_compensation(self) -> float:
        """
        最大补偿量：单次补偿最大值 单位 mm 范围[1,10] 默认 0.4
        """
    @max_compensation.setter
    def max_compensation(self, arg0: float) -> None:
        ...
    @property
    def min_compensation(self) -> float:
        """
        最小补偿量：单次补偿最小值，控制量小于该值不予补偿 单位 mm 范围[1,10] 默认 0.01
        """
    @min_compensation.setter
    def min_compensation(self, arg0: float) -> None:
        ...
    @property
    def pid(self) -> float:
        """
        比例增益：调节上下跟踪的快慢 范围[0,10] 默认 5
        """
    @pid.setter
    def pid(self, arg0: float) -> None:
        ...
    @property
    def sampling_duration_period(self) -> int:
        """
        自适应上下基准电流持续采样周期 范围[1,50] 默认1
        """
    @sampling_duration_period.setter
    def sampling_duration_period(self, arg0: int) -> None:
        ...
    @property
    def sampling_start_period(self) -> int:
        """
        自适应上下基准电流开始采样周期 范围[3,50] 默认 5
        """
    @sampling_start_period.setter
    def sampling_start_period(self, arg0: int) -> None:
        ...
class WMoveCCommand(xCoreSDK_python.MoveCCommand):
    """
    焊接指令 - 圆弧轨迹，摆动参数默认为空
    """
    def __init__(self, target: xCoreSDK_python.CartesianPosition, aux: xCoreSDK_python.CartesianPosition, speed: int = -1, zone: int = -1, weaveData: str = '', trackData: str = '') -> None:
        ...
    def getTrackData(self) -> str:
        ...
    def getWeaveData(self) -> str:
        ...
    def setTrackData(self, trackData: str, ec: dict) -> None:
        ...
    def setWeaveData(self, weaveData: str, ec: dict) -> None:
        ...
    @property
    def arc_set_opt(self) -> ArcSetOpt:
        """
        设置焊接参数选项
        """
    @arc_set_opt.setter
    def arc_set_opt(self, arg0: ArcSetOpt) -> None:
        ...
class WMoveCFCommand(xCoreSDK_python.MoveCFCommand):
    """
    焊接指令 - 整圆轨迹，摆动参数默认为空
    """
    def __init__(self, target: xCoreSDK_python.CartesianPosition, aux: xCoreSDK_python.CartesianPosition, angle: float, speed: int = -1, zone: int = -1, weaveData: str = '', trackData: str = '') -> None:
        ...
    def getTrackData(self) -> str:
        ...
    def getWeaveData(self) -> str:
        ...
    def setTrackData(self, trackData: str, ec: dict) -> None:
        ...
    def setWeaveData(self, weaveData: str, ec: dict) -> None:
        ...
    @property
    def arc_set_opt(self) -> ArcSetOpt:
        """
        设置焊接参数选项
        """
    @arc_set_opt.setter
    def arc_set_opt(self, arg0: ArcSetOpt) -> None:
        ...
class WMoveLCommand(xCoreSDK_python.MoveLCommand):
    """
    焊接指令 - 直线轨迹，摆动参数默认为空
    """
    def __init__(self, target: xCoreSDK_python.CartesianPosition, speed: int = -1, zone: int = -1, weaveData: str = '', trackData: str = '') -> None:
        ...
    def getTrackData(self) -> str:
        ...
    def getWeaveData(self) -> str:
        ...
    def setTrackData(self, trackData: str, ec: dict) -> None:
        ...
    def setWeaveData(self, weaveData: str, ec: dict) -> None:
        ...
    @property
    def arc_set_opt(self) -> ArcSetOpt:
        """
        设置焊接参数选项
        """
    @arc_set_opt.setter
    def arc_set_opt(self, arg0: ArcSetOpt) -> None:
        ...
class WMoveLPendulumCommand(xCoreSDK_python.MoveLCommand):
    """
    焊接指令 - 钟摆，摆动参数默认为空
    """
    @typing.overload
    def __init__(self, startAux: xCoreSDK_python.CartesianPosition, targetAux: xCoreSDK_python.CartesianPosition, target: xCoreSDK_python.CartesianPosition, speed: int = -1, frequency: float = 0.1, dwellTimeLeft: float = 0.0, dwellTimeRight: float = 0.0) -> None:
        ...
    @typing.overload
    def __init__(self, startAux: None, targetAux: xCoreSDK_python.CartesianPosition, target: xCoreSDK_python.CartesianPosition, speed: int = -1, frequency: float = 0.1, dwellTimeLeft: float = 0.0, dwellTimeRight: float = 0.0) -> None:
        ...
    @property
    def dwellTimeLeft(self) -> float:
        """
        左边缘停留时间, 范围[0, 10000], 单位ms
        """
    @dwellTimeLeft.setter
    def dwellTimeLeft(self, arg0: float) -> None:
        ...
    @property
    def dwellTimeRight(self) -> float:
        """
        右边缘停留时间, 范围[0, 10000], 单位ms
        """
    @dwellTimeRight.setter
    def dwellTimeRight(self, arg0: float) -> None:
        ...
    @property
    def enableStartAux(self) -> bool:
        """
        标志位，识别是否使用起始辅助点
        """
    @enableStartAux.setter
    def enableStartAux(self, arg0: bool) -> None:
        ...
    @property
    def frequency(self) -> float:
        """
        摆动频率, 范围[0.1, 5], 单位Hz
        """
    @frequency.setter
    def frequency(self, arg0: float) -> None:
        ...
    @property
    def startAux(self) -> xCoreSDK_python.CartesianPosition:
        """
        起始辅助点位，非首条钟摆可为NULL
        """
    @startAux.setter
    def startAux(self, arg0: xCoreSDK_python.CartesianPosition) -> None:
        ...
    @property
    def startAuxOffset(self) -> xCoreSDK_python.CartesianPositionOffset:
        """
        偏移选项
        """
    @startAuxOffset.setter
    def startAuxOffset(self, arg0: xCoreSDK_python.CartesianPositionOffset) -> None:
        ...
    @property
    def targetAux(self) -> xCoreSDK_python.CartesianPosition:
        """
        目标辅助点位
        """
    @targetAux.setter
    def targetAux(self, arg0: xCoreSDK_python.CartesianPosition) -> None:
        ...
    @property
    def targetAuxOffset(self) -> xCoreSDK_python.CartesianPositionOffset:
        """
        偏移选项
        """
    @targetAuxOffset.setter
    def targetAuxOffset(self, arg0: xCoreSDK_python.CartesianPositionOffset) -> None:
        ...
    @property
    def targetOffset(self) -> xCoreSDK_python.CartesianPositionOffset:
        """
        偏移选项
        """
    @targetOffset.setter
    def targetOffset(self, arg0: xCoreSDK_python.CartesianPositionOffset) -> None:
        ...
class WeaveAdaptiveData:
    """
    摆弧自适应参数
    """
    def __init__(self) -> None:
        ...
    @property
    def groove_width_ratio(self) -> float:
        """
        坡口宽度比例。
        """
    @groove_width_ratio.setter
    def groove_width_ratio(self, arg0: float) -> None:
        ...
    @property
    def groove_width_standard(self) -> float:
        """
        标准坡口宽度。单位：mm。
        """
    @groove_width_standard.setter
    def groove_width_standard(self, arg0: float) -> None:
        ...
    @property
    def isAdaptive(self) -> bool:
        """
        是否自适应。true: 是，false: 否。
        """
    @isAdaptive.setter
    def isAdaptive(self, arg0: bool) -> None:
        ...
    @property
    def max_electric(self) -> float:
        """
        最大电流。单位：A。
        """
    @max_electric.setter
    def max_electric(self, arg0: float) -> None:
        ...
    @property
    def max_groove_width(self) -> float:
        """
        最大坡口宽度。单位：mm。
        """
    @max_groove_width.setter
    def max_groove_width(self, arg0: float) -> None:
        ...
    @property
    def max_speed(self) -> float:
        """
        最大速度。单位：mm/s。
        """
    @max_speed.setter
    def max_speed(self, arg0: float) -> None:
        ...
class WeaveData:
    """
    摆弧参数
    """
    def __init__(self) -> None:
        ...
    @property
    def acc(self) -> float:
        """
        摆动加速度。单位：mm/s²，范围：(0, 5)，开区间
        """
    @acc.setter
    def acc(self, arg0: float) -> None:
        ...
    @property
    def amplitude(self) -> Amplitude:
        """
        摆弧幅度。摆动频率乘左右振幅需小于50
        """
    @amplitude.setter
    def amplitude(self, arg0: Amplitude) -> None:
        ...
    @property
    def annotation(self) -> str:
        """
        文件号注释
        """
    @annotation.setter
    def annotation(self, arg0: str) -> None:
        ...
    @property
    def dwell_time(self) -> list:
        """
        等待时间（左、中、右）。单位：ms。暂不支持中间停留时间设置
        """
    @dwell_time.setter
    def dwell_time(self, arg1: list) -> None:
        ...
    @property
    def dwell_type(self) -> str:
        """
        等待类型（三角摆和正弦摆有效）。机器人等待："robot_stay"，摆动停止："weave_stop"
        """
    @dwell_type.setter
    def dwell_type(self, arg0: str) -> None:
        ...
    @property
    def elevation_angle(self) -> ElevationAngle:
        """
        仰角。当仰角类型为“V型”时，角度设置为0，机器人在单平面动；当仰角类型为“三角”时，两个角度之和不能为0、180、-180
        """
    @elevation_angle.setter
    def elevation_angle(self, arg0: ElevationAngle) -> None:
        ...
    @property
    def elevation_type(self) -> str:
        """
        仰角类型（三角摆生效）。V型："v_pattern"，三角："triangular"
        """
    @elevation_type.setter
    def elevation_type(self, arg0: str) -> None:
        ...
    @property
    def inclination_angle(self) -> float:
        """
        倾斜角（三角摆和圆弧摆生效）。单位：°，范围：[-90, 90]
        """
    @inclination_angle.setter
    def inclination_angle(self, arg0: float) -> None:
        ...
    @property
    def jerk(self) -> float:
        """
        摆动加加速度。单位：mm/s³，范围：(0, 50]
        """
    @jerk.setter
    def jerk(self, arg0: float) -> None:
        ...
    @property
    def name(self) -> str:
        """
        文件号名
        """
    @name.setter
    def name(self, arg0: str) -> None:
        ...
    @property
    def pattern(self) -> str:
        """
        摆弧形状。三角："triangular"，正弦："sine"，圆弧："circular"，8字："figure_8"
        """
    @pattern.setter
    def pattern(self, arg0: str) -> None:
        ...
    @property
    def phase_invert(self) -> bool:
        """
        波形反向（暂不支持，默认正向）。反向：true；正向：false
        """
    @phase_invert.setter
    def phase_invert(self, arg0: bool) -> None:
        ...
    @property
    def radius(self) -> float:
        """
        摆弧半径（圆弧、8字生效）。单位：mm，范围：[0.1, 100]
        """
    @radius.setter
    def radius(self, arg0: float) -> None:
        ...
    @property
    def weave_length_frequency(self) -> float:
        """
        摆弧长度、频率（与摆弧基准匹配）。长度：单位：mm，范围：[1, 500]；频率：单位：Hz，范围：[0.1, 5]
        """
    @weave_length_frequency.setter
    def weave_length_frequency(self, arg0: float) -> None:
        ...
    @property
    def weaving_reference(self) -> str:
        """
        摆弧基准（只支持基于周期的摆动）。长度："length"，周期："cycle"
        """
    @weaving_reference.setter
    def weaving_reference(self, arg0: str) -> None:
        ...
class WeaveOffCommand:
    """
    焊接指令 - 停止摆动
    """
    def __init__(self) -> None:
        ...
class WeaveOnCommand:
    """
    焊接指令 - 开始摆动
    """
    def __init__(self, weaveData: str = 'default') -> None:
        ...
    def getWeaveData(self) -> str:
        ...
    def setWeaveData(self, weaveData: str, ec: dict) -> None:
        ...
class WeldMode:
    """
    焊接模式
    
    Members:
    
      TestRun : 空运行
    
      Simu : 仿真
    
      Real : 实焊
    """
    Real: typing.ClassVar[WeldMode]  # value = <WeldMode.Real: 2>
    Simu: typing.ClassVar[WeldMode]  # value = <WeldMode.Simu: 1>
    TestRun: typing.ClassVar[WeldMode]  # value = <WeldMode.TestRun: 0>
    __members__: typing.ClassVar[dict[str, WeldMode]]  # value = {'TestRun': <WeldMode.TestRun: 0>, 'Simu': <WeldMode.Simu: 1>, 'Real': <WeldMode.Real: 2>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class WelderSetting:
    """
    焊机设置
    """
    def __init__(self) -> None:
        ...
    @property
    def current_file(self) -> str:
        """
        电流文件号
        """
    @current_file.setter
    def current_file(self, arg0: str) -> None:
        ...
    @property
    def current_type(self) -> int:
        """
        电流类型
        """
    @current_type.setter
    def current_type(self, arg0: int) -> None:
        ...
    @property
    def mfr(self) -> str:
        """
        厂商
        """
    @mfr.setter
    def mfr(self, arg0: str) -> None:
        ...
    @property
    def model(self) -> str:
        """
        焊机型号
        """
    @model.setter
    def model(self, arg0: str) -> None:
        ...
    @property
    def program_number(self) -> int:
        """
        程序号
        """
    @program_number.setter
    def program_number(self, arg0: int) -> None:
        ...
    @property
    def protocol(self) -> str:
        """
        协议
        """
    @protocol.setter
    def protocol(self, arg0: str) -> None:
        ...
    @property
    def shielding_gas(self) -> str:
        """
        保护气体
        """
    @shielding_gas.setter
    def shielding_gas(self, arg0: str) -> None:
        ...
    @property
    def voltage_file(self) -> str:
        """
        电压文件号
        """
    @voltage_file.setter
    def voltage_file(self, arg0: str) -> None:
        ...
    @property
    def wire_diameter(self) -> float:
        """
        焊丝直径
        """
    @wire_diameter.setter
    def wire_diameter(self, arg0: float) -> None:
        ...
class WelderStatus:
    """
    焊接状态
    """
    def __init__(self) -> None:
        ...
    @property
    def arc_welding(self) -> int:
        """
        当前的焊接状态；类型int，0 - 起弧，1 - 焊接状态，2 - 熄弧状态，-1 - 默认值
        """
    @arc_welding.setter
    def arc_welding(self, arg0: int) -> None:
        ...
    @property
    def current(self) -> float:
        """
        当前电流。单位：A
        """
    @current.setter
    def current(self, arg0: float) -> None:
        ...
    @property
    def running_error(self) -> dict:
        """
        运行错误码
        """
    @property
    def speed(self) -> int:
        """
        焊接速度。单位：mm/s
        """
    @speed.setter
    def speed(self, arg0: int) -> None:
        ...
    @property
    def state(self) -> str:
        """
        焊机状态
        """
    @state.setter
    def state(self, arg0: str) -> None:
        ...
    @property
    def voltage(self) -> float:
        """
        当前电压。单位：V
        """
    @voltage.setter
    def voltage(self, arg0: float) -> None:
        ...
    @property
    def welding_distance(self) -> float:
        """
        一次起弧收弧的已经完成焊接距离，下次起弧清空；单位：m
        """
    @welding_distance.setter
    def welding_distance(self, arg0: float) -> None:
        ...
    @property
    def welding_name(self) -> str:
        """
        正在焊接的文件号；类型string，结合arc_welding使用
        """
    @welding_name.setter
    def welding_name(self, arg0: str) -> None:
        ...
    @property
    def welding_path_num(self) -> int:
        """
        一次起弧收弧的焊接路径数量, 即已经开始执行的WMoveLCommand/WMoveCCommand指令数量，下次起弧清空
        """
    @welding_path_num.setter
    def welding_path_num(self, arg0: int) -> None:
        ...
CRNT: LaserSensorType  # value = <LaserSensorType.CRNT: 0>
INTELLIGENT: LaserSensorType  # value = <LaserSensorType.INTELLIGENT: 2>
Real: WeldMode  # value = <WeldMode.Real: 2>
SMART_IMAGE: LaserSensorType  # value = <LaserSensorType.SMART_IMAGE: 1>
Simu: WeldMode  # value = <WeldMode.Simu: 1>
TestRun: WeldMode  # value = <WeldMode.TestRun: 0>
