"""
焊接状态

Current: 焊接电流; 类型double, 单位: A
Voltage: 焊接电压; 类型double, 单位: V
State: 焊接状态; 类型string, "ok"：启用，"disable"：未启用
Speed: 焊接速度; 类型int, 单位: mm/s
RunningError: 焊接运行中的错误; 类型error_code
WeldingName: 正在焊接的文件号; 类型string
ArcWelding: 当前的焊接状态; 类型int，0 - 起弧，1 - 焊接状态，2 - 熄弧状态，-1 - 默认值
WeldingDistance: 一次起弧收弧焊接距离; 类型double, 单位: m
WeldingPathNum: 一次起弧收弧焊接路径数量; 类型int
"""
from __future__ import annotations
__all__ = ['ArcWelding', 'Current', 'RunningError', 'Speed', 'State', 'Voltage', 'WeldingDistance', 'WeldingName', 'WeldingPathNum']
ArcWelding: str = 'arc_welding'
Current: str = 'current'
RunningError: str = 'runningError'
Speed: str = 'speed'
State: str = 'state'
Voltage: str = 'voltage'
WeldingDistance: str = 'distance'
WeldingName: str = 'welding_name'
WeldingPathNum: str = 'pathNumber'
