from __future__ import annotations
import pybind11_stubgen.typing_ext
import typing
import xCoreSDK_python
__all__ = ['CIRCULAR', 'DwellType', 'PyWelding', 'ROBOT_STAY', 'SINE', 'WEAVE_STOP', 'WeaveParams', 'WeavingType', 'ZIGZAG']
class DwellType:
    """
    停留类型
    
    Members:
    
      ROBOT_STAY : 机器人停留
    
      WEAVE_STOP : 摆动停留
    """
    ROBOT_STAY: typing.ClassVar[DwellType]  # value = <DwellType.ROBOT_STAY: 0>
    WEAVE_STOP: typing.ClassVar[DwellType]  # value = <DwellType.WEAVE_STOP: 1>
    __members__: typing.ClassVar[dict[str, DwellType]]  # value = {'ROBOT_STAY': <DwellType.ROBOT_STAY: 0>, 'WEAVE_STOP': <DwellType.WEAVE_STOP: 1>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class PyWelding:
    """
    用于在python中使用welding类
    """
    def __init__(self, arg0: xCoreSDK_python.BaseRobot) -> None:
        ...
    def setSwingMotion(self, acceleration: float, jerk: float, ec: dict) -> None:
        """
        设置摆动加速度和加加速度
        
        Args:
            acceleration (float): 加速度
            jerk (float): 加加速度
            ec (dict): 错误码
        """
    def setWeave(self, enable: bool, ec: dict, frequency: float = 0.0, amplitude: float = 0.0, dwell_time: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)] = [0.0, 0.0, 0.0]) -> None:
        """
        开始/停止摆动。开始摆动时可设置摆动参数
        
        Args:
            enable (bool): true - 开始 | false - 关闭
            ec (dict): 错误码
            frequency (float): 摆动频率, 范围[0.1, 5], 单位: Hz
            amplitude (float): 单侧摆动幅值, 范围[0.0001, 0.05], 单位: 米
            dwell_time (list[float]): 停留时间 [左, 中, 右]，目前只支持左和右, 范围[0, 2], 单位: 秒
        """
    @typing.overload
    def setWeaveParameters(self, frequency: float, amplitude: float, ec: dict, dwell_time: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)] = [0.0, 0.0, 0.0], weavingType: WeavingType = ...) -> None:
        """
        设置摆动参数，支持在摆动过程中调整
        
        Args:
            frequency (float): 摆动频率, 范围[0.1, 5], 单位: Hz
            amplitude (float): 单侧摆动幅值, 范围[0.0001, 0.05], 单位: 米
            ec (dict): 错误码
            dwell_time (list[float]): 停留时间 [左, 中, 右]，目前只支持左和右, 范围[0, 2], 单位: 秒
        """
    @typing.overload
    def setWeaveParameters(self, weaveParams: WeaveParams, ec: dict) -> None:
        """
        设置摆动参数，支持在摆动过程中调整
        
        Args:
            weaveParams: 摆动参数
            ec (dict): 错误码
        """
class WeaveParams:
    """
    摆动参数
    """
    def __init__(self) -> None:
        ...
    @property
    def amplitude(self) -> float:
        """
        幅度，单位: 米, 范围: [0.0001, 0.05]
        """
    @amplitude.setter
    def amplitude(self, arg0: float) -> None:
        ...
    @property
    def dwell_time(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)]:
        """
        停留时间，[左, 中, 右]，单位: 秒，范围: >=0
        """
    @dwell_time.setter
    def dwell_time(self, arg0: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)]) -> None:
        ...
    @property
    def dwell_type(self) -> DwellType:
        """
        停留类型. 圆弧摆需要设为摆动停留
        """
    @dwell_type.setter
    def dwell_type(self, arg0: DwellType) -> None:
        ...
    @property
    def elevation_angle(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(2)]:
        """
        仰角，[左，右]，单位: 弧度
        """
    @elevation_angle.setter
    def elevation_angle(self, arg0: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(2)]) -> None:
        ...
    @property
    def frequency(self) -> float:
        """
        摆动频率，单位: Hz, 范围: [0.1, 5]
        """
    @frequency.setter
    def frequency(self, arg0: float) -> None:
        ...
    @property
    def inclination_angle(self) -> float:
        """
        倾斜角度，单位: 弧度
        """
    @inclination_angle.setter
    def inclination_angle(self, arg0: float) -> None:
        ...
    @property
    def phase_invert(self) -> bool:
        """
        波形反向.true - 向右或逆时针摆动,false - 向左或顺时针摆动
        """
    @phase_invert.setter
    def phase_invert(self, arg0: bool) -> None:
        ...
    @property
    def radius(self) -> float:
        """
        圆弧摆动半径，单位: 米
        """
    @radius.setter
    def radius(self, arg0: float) -> None:
        ...
    @property
    def weaveing_type(self) -> WeavingType:
        """
        摆动形状
        """
    @weaveing_type.setter
    def weaveing_type(self, arg0: WeavingType) -> None:
        ...
class WeavingType:
    """
    摆动形状
    
    Members:
    
      ZIGZAG : 三角摆动
    
      SINE : 正弦摆动
    
      CIRCULAR : 圆弧摆动
    """
    CIRCULAR: typing.ClassVar[WeavingType]  # value = <WeavingType.CIRCULAR: 2>
    SINE: typing.ClassVar[WeavingType]  # value = <WeavingType.SINE: 1>
    ZIGZAG: typing.ClassVar[WeavingType]  # value = <WeavingType.ZIGZAG: 0>
    __members__: typing.ClassVar[dict[str, WeavingType]]  # value = {'ZIGZAG': <WeavingType.ZIGZAG: 0>, 'SINE': <WeavingType.SINE: 1>, 'CIRCULAR': <WeavingType.CIRCULAR: 2>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
CIRCULAR: WeavingType  # value = <WeavingType.CIRCULAR: 2>
ROBOT_STAY: DwellType  # value = <DwellType.ROBOT_STAY: 0>
SINE: WeavingType  # value = <WeavingType.SINE: 1>
WEAVE_STOP: DwellType  # value = <DwellType.WEAVE_STOP: 1>
ZIGZAG: WeavingType  # value = <WeavingType.ZIGZAG: 0>
