using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml.Schema;
using rokae.clr;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.TaskbarClock;
using static rokae.clr.ArcWelding;
using static rokae.clr.xPanelOpt;
using EventInfos = System.Collections.Generic.Dictionary<System.String, System.Object>;

namespace xCoreSDK_CSharp.examples
{
    public class ArcWeldingDemo
    {
        internal xMateRobotDemo robotDemo;
        internal ArcWelding arcWelding;
        internal ErrorCode ec = new ErrorCode(0, "");
        internal bool toInfoBox = false;

        // 设置焊接模式示例，焊接模式切换需要遵循特定的顺序
        public void SetWeldModeExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetWeldModeExample");

            WeldMode weldMode = WeldMode.TestRun;
            arcwelding.setWeldMode(weldMode, out ec);
            printErrorCode("setWeldMode", ec);
            WeldMode weldModeRet = arcwelding.getWeldMode(out ec);
            printErrorCode("getWeldMode", ec);
            printInfo($"set: TestRun, return: {weldModeRet.ToString()}");
            Thread.Sleep(1000);

            weldMode = WeldMode.Simu;
            arcwelding.setWeldMode(weldMode, out ec);
            printErrorCode("setWeldMode", ec);
            weldModeRet = arcwelding.getWeldMode(out ec);
            printErrorCode("getWeldMode", ec);
            printInfo($"set: Simu, return: {weldModeRet.ToString()}");
            Thread.Sleep(1000);

            weldMode = WeldMode.Real;
            arcwelding.setWeldMode(weldMode, out ec);
            printErrorCode("setWeldMode", ec);
            weldModeRet = arcwelding.getWeldMode(out ec);
            printErrorCode("getWeldMode", ec);
            printInfo($"set: Real, return: {weldModeRet.ToString()}");
        }

        // 设置起弧参数示例
        public void SetArcOnDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetArcOnDataExample");
            // 下发ArcOnData默认值
            ArcOnData arcOnDataDefault = ArcOnData.CreateDefault();
            arcwelding.setArcOnData(arcOnDataDefault, out ec);
            printErrorCode("setArcOnData", ec);


            // 下发ArcOnData自定义值
            ArcOnData arcOnDataCustom = new ArcOnData
            {
                name = "Custom1_name",
                annotation = "Custom1_annotation",
                mode = "low_spatter",
                current_mode = "wire_feed",
                voltage_mode = "separate",
                current = 120,
                voltage = 2,
                hold_time = 200,
                detect_time = 500,
                confirm_time = 50,
                preflow_time = 200,
                prearc_time = 50,
                slow_wire_feed_speed = 8,
                pre_wirefeed_time = 10,
                ramp_time = 100,
                re_arcon = new ReArcOnParam
                {
                    enable = true,
                    retry_time = 3,
                    wire_retract_delay_time = 0,
                    wire_retract_time = 100,
                    current_step = 10,
                    voltage_step = 0.1,
                },
                scratch_arcon = new ScratchArconParam
                {
                    enable = false,
                    distance = 50,
                    back_speed = 10,
                    step = 5,
                }
            };
            arcwelding.setArcOnData(arcOnDataCustom, out ec);
            printErrorCode("setArcOnData", ec);

            // 获取ArcOnData
            var arcOnDataDefaultRet = arcwelding.getArcOnData(arcOnDataDefault.name, out ec);
            printErrorCode("getArcOnData", ec);
            var arcOnDataCustomRet = arcwelding.getArcOnData(arcOnDataCustom.name, out ec);
            printErrorCode("getArcOnData", ec);

            // 打印ArcOnData
            Action<ArcOnData> printArcOnData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Annotation: {data.annotation}");
                printInfo($"Mode: {data.mode}");
                printInfo($"Current Mode: {data.current_mode}");
                printInfo($"Voltage Mode: {data.voltage_mode}");
                printInfo($"Current: {data.current}");
                printInfo($"Voltage: {data.voltage}");
                printInfo($"Hold Time: {data.hold_time}");
                printInfo($"Detect Time: {data.detect_time}");
                printInfo($"Confirm Time: {data.confirm_time}");
                printInfo($"Preflow Time: {data.preflow_time}");
                printInfo($"Prearc Time: {data.prearc_time}");
                printInfo($"Slow Wire Feed Speed: {data.slow_wire_feed_speed}");
                printInfo($"Pre Wirefeed Time: {data.pre_wirefeed_time}");
                printInfo($"Ramp Time: {data.ramp_time}");

                printInfo("Re Arc On Parameters:");
                printInfo($"  Enable: {data.re_arcon.enable}");
                printInfo($"  Retry Time: {data.re_arcon.retry_time}");
                printInfo($"  Wire Retract Delay Time: {data.re_arcon.wire_retract_delay_time}");
                printInfo($"  Wire Retract Time: {data.re_arcon.wire_retract_time}");
                printInfo($"  Current Step: {data.re_arcon.current_step}");
                printInfo($"  Voltage Step: {data.re_arcon.voltage_step}");

                printInfo("Scratch Arc On Parameters:");
                printInfo($"  Enable: {data.scratch_arcon.enable}");
                printInfo($"  Distance: {data.scratch_arcon.distance}");
                printInfo($"  Back Speed: {data.scratch_arcon.back_speed}");
                printInfo($"  Step: {data.scratch_arcon.step}");
            };
            printArcOnData(arcOnDataDefaultRet);
            printArcOnData(arcOnDataCustomRet);

            // 删除参数
            arcwelding.removeArcOnData("default", out ec);
            printErrorCode("removeArcOnData", ec);
            arcwelding.removeArcOnData(new List<string> { "remove1", "remove2" }, out ec);
            printErrorCode("removeArcOnData", ec);
        }

        // 设置焊接参数示例
        public void SetArcDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetArcDataExample");
            // 下发ArcData默认值
            ArcData arcDataDefault = ArcData.CreateDefault();
            arcwelding.setArcData(arcDataDefault, out ec);
            printErrorCode("setArcData", ec);

            // 下发ArcData自定义值
            ArcData arcDataCustom = new ArcData
            {
                name = "Custom1_name",
                annotation = "Custom1_annotation",
                mode = "low_spatter",
                current_mode = "wire_feed",
                voltage_mode = "separate",
                current = 80,
                voltage = 2,
                weld_speed = 50,
                ramp_time = 200,
                arc_break_param = new ArcBreakParam
                {
                    detect_time = 50,
                    arc_break_option = "stop_and_alarm",
                    restart_back_distance = 0
                }
            };
            arcwelding.setArcData(arcDataCustom, out ec);
            printErrorCode("setArcData", ec);

            // 获取ArcData
            var arcDataDefaultRet = arcwelding.getArcData(arcDataDefault.name, out ec);
            printErrorCode("getArcData", ec);
            var arcDataCustomRet = arcwelding.getArcData(arcDataCustom.name, out ec);
            printErrorCode("getArcData", ec);

            // 打印ArcData
            Action<ArcData> printArcData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Annotation: {data.annotation}");
                printInfo($"Mode: {data.mode}");
                printInfo($"Current Mode: {data.current_mode}");
                printInfo($"Voltage Mode: {data.voltage_mode}");
                printInfo($"Current: {data.current}");
                printInfo($"Voltage: {data.voltage}");
                printInfo($"Weld Speed: {data.weld_speed}");
                printInfo($"Ramp Time: {data.ramp_time}");

                printInfo("Arc Break Parameters:");
                printInfo($"  Detect Time: {data.arc_break_param.detect_time}");
                printInfo($"  Arc Break Option: {data.arc_break_param.arc_break_option}");
                printInfo($"  Restart Back Distance: {data.arc_break_param.restart_back_distance}");
            };

            printArcData(arcDataDefaultRet);
            printArcData(arcDataCustomRet);

            // 删除ArcData
            arcwelding.removeArcData("default", out ec);
            printErrorCode("removeArcData", ec);
            arcwelding.removeArcData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeArcData", ec);
        }

        // 设置收弧参数示例
        public void SetArcOffDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("SetArcOffDataExample");
            // 下发ArcOffData
            ArcOffData arcOffDataDefault = ArcOffData.CreateDefault(); // 默认值
            arcwelding.setArcOffData(arcOffDataDefault, out ec);
            printErrorCode("setArcOffData", ec);

            ArcOffData arcOffDataCustom = new ArcOffData // 自定义值
            {
                name = "Custom1_name",
                annotation = "Custom1_annotation",
                mode = "low_spatter",
                current_mode = "wire_feed",
                voltage_mode = "separate",
                current = 160,
                voltage = 5,
                hold_time = 200,
                delay_gasoff_time = 200,
                detect_time = 100,
                retract_time = 80,
                wire_stick_detection_time = 80,
                anti_wire_stick_param = new AntiWireStickParam
                {
                    enable = false,
                    current = 0,
                    voltage = 0,
                    time = 100,
                }
            };
            arcwelding.setArcOffData(arcOffDataCustom, out ec);
            printErrorCode("setArcOffData", ec);

            // 获取ArcOffData
            var arcOffDataDefaultRet = arcwelding.getArcOffData(arcOffDataDefault.name, out ec);
            printErrorCode("getArcOffData", ec);
            var arcOffDataCustomRet = arcwelding.getArcOffData(arcOffDataCustom.name, out ec);
            printErrorCode("getArcOffData", ec);

            // 打印ArcOffData
            Action<ArcOffData> printArcOffData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Annotation: {data.annotation}");
                printInfo($"Mode: {data.mode}");
                printInfo($"Current Mode: {data.current_mode}");
                printInfo($"Voltage Mode: {data.voltage_mode}");
                printInfo($"Current: {data.current}");
                printInfo($"Voltage: {data.voltage}");
                printInfo($"Hold Time: {data.hold_time}");
                printInfo($"Delay Gas Off Time: {data.delay_gasoff_time}");
                printInfo($"Detect Time: {data.detect_time}");
                printInfo($"Retract Time: {data.retract_time}");
                printInfo($"Wire Stick Detection Time: {data.wire_stick_detection_time}");

                printInfo("Anti Wire Stick Parameters:");
                printInfo($"  Enable: {data.anti_wire_stick_param.enable}");
                printInfo($"  Current: {data.anti_wire_stick_param.current}");
                printInfo($"  Voltage: {data.anti_wire_stick_param.voltage}");
                printInfo($"  Time: {data.anti_wire_stick_param.time}");
            };

            printArcOffData(arcOffDataDefaultRet);
            printArcOffData(arcOffDataCustomRet);

            // 删除ArcOffData
            arcwelding.removeArcOffData("default", out ec);
            printErrorCode("removeArcOffData", ec);
            arcwelding.removeArcOffData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeArcOffData", ec);
        }

        // 设置摆动参数示例
        public void SetWeaveDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetWeaveDataExample");
            // 下发WeaveData
            WeaveData weaveDataDefault = WeaveData.CreateDefault(); // 默认值
            arcwelding.setWeaveData(weaveDataDefault, out ec);
            printErrorCode("setWeaveData", ec);

            WeaveData weaveDataCustom = new WeaveData // 自定义值
            {
                name = "Custom_name",
                annotation = "Custom_annotation",
                weaving_reference = "cycle",
                pattern = "sine",
                weave_length_frequency = 1,
                amplitude = new Amplitude
                {
                    left = 2,
                    right = 2,
                },
                dwell_type = "weave_stop",
                dwell_time = new int[] { 10, 0, 20 },
                radius = 5,
                phase_invert = true,
                elevation_type = "v_pattern",
                elevation_angle = new ElevationAngle
                {
                    left = 0,
                    right = 0,
                },
                inclination_angle = 0,
                acc = 1,
                jerk = 10
            };
            arcwelding.setWeaveData(weaveDataCustom, out ec);
            printErrorCode("setWeaveData", ec);

            // 获取WeaveData
            var weaveDataDefaultRet = arcwelding.getWeaveData(weaveDataDefault.name, out ec);
            printErrorCode("getWeaveData", ec);
            var weaveDataCustomRet = arcwelding.getWeaveData(weaveDataCustom.name, out ec);
            printErrorCode("getWeaveData", ec);

            // 打印WeaveData
            Action<WeaveData> printWeaveData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Annotation: {data.annotation}");
                printInfo($"Weaving Reference: {data.weaving_reference}");
                printInfo($"Pattern: {data.pattern}");
                printInfo($"Weave Length Frequency: {data.weave_length_frequency}");

                printInfo("Amplitude:");
                printInfo($"  Left: {data.amplitude.left}");
                printInfo($"  Right: {data.amplitude.right}");

                printInfo($"Dwell Type: {data.dwell_type}");
                printInfo($"Dwell Time: {data.dwell_time[0]}, {data.dwell_time[1]}, {data.dwell_time[2]}");
                printInfo($"Radius: {data.radius}");
                printInfo($"Phase Invert: {data.phase_invert}");
                printInfo($"Elevation Type: {data.elevation_type}");

                printInfo("Elevation Angle:");
                printInfo($"  Left: {data.elevation_angle.left}");
                printInfo($"  Right: {data.elevation_angle.right}");

                printInfo($"Inclination Angle: {data.inclination_angle}");
                printInfo($"Acc: {data.acc}");
                printInfo($"Jerk: {data.jerk}");
            };

            printWeaveData(weaveDataDefaultRet);
            printWeaveData(weaveDataCustomRet);

            // 删除WeaveData
            arcwelding.removeWeaveData("default", out ec);
            printErrorCode("removeWeaveData", ec);
            arcwelding.removeWeaveData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeWeaveData", ec);
        }

        // 设置间断焊参数示例
        public void SetSegDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetSegDataExample");
            // 下发SegData
            SegData segDataDefault = SegData.CreateDefault(); // 默认值
            arcwelding.setSegData(segDataDefault, out ec);
            printErrorCode("setSegData", ec);

            SegData segDataCustom = new SegData // 自定义值
            {
                name = "Custom_name",
                annotation = "Custom_annotation",
                seg_type = "normal",
                non_welded_speed = "v10",
                welded_distance = 10,
                non_welded_distance = 20
            };
            arcwelding.setSegData(segDataCustom, out ec);
            printErrorCode("setSegData", ec);

            // 获取SegData
            var segDataDefaultRet = arcwelding.getSegData("default", out ec);
            printErrorCode("getSegData", ec);
            var segDataCustomRet = arcwelding.getSegData(segDataCustom.name, out ec);
            printErrorCode("getSegData", ec);

            // 打印SegData
            Action<SegData> printSegData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Annotation: {data.annotation}");
                printInfo($"Segment Type: {data.seg_type}");
                printInfo($"Non-Welded Speed: {data.non_welded_speed}");
                printInfo($"Welded Distance: {data.welded_distance}");
                printInfo($"Non-Welded Distance: {data.non_welded_distance}");
            };

            printSegData(segDataDefaultRet);
            printSegData(segDataCustomRet);

            // 删除SegData
            arcwelding.removeSegData("default", out ec);
            printErrorCode("removeSegData", ec);
            arcwelding.removeSegData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeSegData", ec);
        }

        // 设置激光跟踪参数示例
        public void SetLaserTrackDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetLaserTrackDataExample");
            // 下发LaserTrackData
            LaserTrackData laserTrackDataDefault = LaserTrackData.CreateDefault(); // 默认值
            arcwelding.setLaserTrackData(laserTrackDataDefault, out ec);
            printErrorCode("setLaserTrackData", ec);

            LaserTrackData laserTrackDataCustom = new LaserTrackData // 自定义值
            {
                name = "Custom_name",
                job_number = 2,
                y_comp = true,
                z_comp = true,
                max_invalid_length = 20
            };
            arcwelding.setLaserTrackData(laserTrackDataCustom, out ec);
            printErrorCode("setLaserTrackData", ec);

            // 获取LaserTrackData
            var laserTrackDataDefaultRet = arcwelding.getLaserTrackData("default", out ec);
            printErrorCode("getLaserTrackData", ec);
            var laserTrackDataCustomRet = arcwelding.getLaserTrackData(laserTrackDataCustom.name, out ec);
            printErrorCode("getLaserTrackData", ec);

            // 打印LaserTrackData
            Action<LaserTrackData> printLaserTrackData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Job Number: {data.job_number}");
                printInfo($"Y Compensation: {data.y_comp}");
                printInfo($"Z Compensation: {data.z_comp}");
                printInfo($"max_invalid_length: {data.max_invalid_length}");
            };

            printLaserTrackData(laserTrackDataDefaultRet);
            printLaserTrackData(laserTrackDataCustomRet);

            // 删除LaserTrackData
            arcwelding.removeLaserTrackData("default", out ec);
            printErrorCode("removeLaserTrackData", ec);
            arcwelding.removeLaserTrackData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeLaserTrackData", ec);
        }

        // 设置激光寻位参数示例
        public void SetLaserSearchDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetLaserSearchDataExample");
            // 下发LaserSearchData
            LaserSearchData laserSearchDataDefault = LaserSearchData.CreateDefault(); // 默认值
            arcwelding.setLaserSearchData(laserSearchDataDefault, out ec);
            printErrorCode("setLaserSearchData", ec);

            LaserSearchData laserSearchDataCustom = new LaserSearchData // 自定义值
            {
                name = "Custom_name",
                job_number = 2,
                search_type = "point",
                search_mode = "continuous",
                step_length = 3,
                joint_type = "lap_joint",
            };
            arcwelding.setLaserSearchData(laserSearchDataCustom, out ec);
            printErrorCode("setLaserSearchData", ec);

            // 获取LaserSearchData
            var laserSearchDataDefaultRet = arcwelding.getLaserSearchData("default", out ec);
            printErrorCode("getLaserSearchData", ec);
            var laserSearchDataCustomRet = arcwelding.getLaserSearchData(laserSearchDataCustom.name, out ec);
            printErrorCode("getLaserSearchData", ec);

            // 打印LaserSearchData
            Action<LaserSearchData> printLaserSearchData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Job Number: {data.job_number}");
                printInfo($"Search Type: {data.search_type}");
                printInfo($"Search Mode: {data.search_mode}");
                printInfo($"Step Length: {data.step_length}");
                printInfo($"Joint Type: {data.joint_type}");
            };

            printLaserSearchData(laserSearchDataDefaultRet);
            printLaserSearchData(laserSearchDataCustomRet);

            // 删除LaserSearchData
            arcwelding.removeLaserSearchData("default", out ec);
            printErrorCode("removeLaserSearchData", ec);
            arcwelding.removeLaserSearchData(new List<string> { "remove1,remove2" }, out ec);
            printErrorCode("removeLaserSearchData", ec);
        }

        // 设置电弧跟踪参数示例
        public void SetArcTrackDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter setArcTrackData");

            Action<ArcTrackParam> printArcTrackData = (arcTrackData) =>
            {
                printInfo($"name: {arcTrackData.name}\n" +
                                  $"annotation: {arcTrackData.annotation}\n" +
                                  $"delay_time: {arcTrackData.delay_time}\n" +
                                  $"cycle: {arcTrackData.cycle}\n" +
                                  $"lr_enable: {arcTrackData.lr_enable}\n" +
                                  $"ud_enable: {arcTrackData.ud_enable}\n" +
                                  "LrTrackParam:\n" +
                                  $"  pid: {arcTrackData.lr_param.pid}\n" +
                                  $"  curr_bias_offset: {arcTrackData.lr_param.curr_bias_offset}\n" +
                                  $"  min_compensation: {arcTrackData.lr_param.min_compensation}\n" +
                                  $"  max_compensation: {arcTrackData.lr_param.max_compensation}\n" +
                                  "UdTrackParam:\n" +
                                  $"  pid: {arcTrackData.ud_param.pid}\n" +
                                  $"  curr_bias_offset: {arcTrackData.ud_param.curr_bias_offset}\n" +
                                  $"  min_compensation: {arcTrackData.ud_param.min_compensation}\n" +
                                  $"  max_compensation: {arcTrackData.ud_param.max_compensation}\n" +
                                  $"  base_current: {arcTrackData.ud_param.base_current}\n" +
                                  $"  sampling_start_period: {arcTrackData.ud_param.sampling_start_period}\n" +
                                  $"  sampling_duration_period: {arcTrackData.ud_param.sampling_duration_period}");
            };

            LrTrackParam lrTrackData = new LrTrackParam
            {
                pid = 6,
                curr_bias_offset = 6,
                min_compensation = 0.02,
                max_compensation = 0.8
            };

            UdTrackParam udTrackData = new UdTrackParam
            {
                pid = 6,
                curr_bias_offset = 6,
                min_compensation = 0.02,
                max_compensation = 0.8,
                base_current = 0.1,
                sampling_start_period = 6,
                sampling_duration_period = 2
            };

            ArcTrackParam arcTrackData = new ArcTrackParam
            {
                name = "track2",
                annotation = "trackannotation",
                delay_time = 2,
                cycle = 3,
                lr_enable = true,
                ud_enable = true,
                lr_param = lrTrackData,
                ud_param = udTrackData
            };

            arcwelding.setArcTrackParam(arcTrackData, out ec);
            printErrorCode("setArcTrackParam", ec);

            var ret = arcwelding.getArcTrackParam("track2", out ec);
            printErrorCode("getArcTrackParam", ec);
            printArcTrackData(ret);
        }

        // 设置模拟量端口示例
        public void SetIOSettingExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetIOSettingExample");
            // 下发IOSetting
            IOSetting ioSetting = new IOSetting
            {
                arc_on = { name = "DO0_1", type = 2, bias = -1, enable = true },
                wire_feed = { name = "DO0_2", type = 2, bias = -1, enable = true },      // wire_feed
                wire_feed_back = { name = "DO0_0", type = 2, bias = -1, enable = false },     // wire_feed_back
                gas_test = { name = "DO0_0", type = 2, bias = -1, enable = false },     // gas_test
                positioning_enable = { name = "DO0_0", type = 2, bias = -1, enable = false },     // positioning_enable
                arc_on_success = { name = "DI0_0", type = 1, bias = -1, enable = false },     // arc_on_success
                positioning_feedback = { name = "DI0_0", type = 1, bias = -1, enable = false },     // positioning_feedback
                current_set = { name = "register3", type = 5, bias = 0, enable = true },   // current_set
                voltage_set = { name = "register4", type = 5, bias = 0, enable = true },   // voltage_set
                current_get = { name = "register0", type = 5, bias = 0, enable = true },   // current_get
                voltage_get = { name = "register2", type = 5, bias = -1, enable = false }, // voltage_get
                robot_ready = { name = "DO0_0", type = 2, bias = -1, enable = true },      // robot_ready
                error = { name = "DI1_1", type = 1, bias = 1, enable = false }       // error
            };
            arcwelding.setIOSetting(ioSetting, out ec);
            printErrorCode("setIOSetting", ec);

            // 获取IOSetting
            var ioSettingRet = arcwelding.getIOSetting(out ec);
            printErrorCode("setIOSetting", ec);

            // 打印IOSetting
            Action<IOSetting> printIOSetting = data =>
            {
                printInfo("IO Setting:");
                PrintIOConfig("Arc On", data.arc_on);
                PrintIOConfig("Wire Feed", data.wire_feed);
                PrintIOConfig("Wire Feed Back", data.wire_feed_back);
                PrintIOConfig("Gas Test", data.gas_test);
                PrintIOConfig("Positioning Enable", data.positioning_enable);
                PrintIOConfig("Arc On Success", data.arc_on_success);
                PrintIOConfig("Positioning Feedback", data.positioning_feedback);
                PrintIOConfig("Current Set", data.current_set);
                PrintIOConfig("Voltage Set", data.voltage_set);
                PrintIOConfig("Current Get", data.current_get);
                PrintIOConfig("Voltage Get", data.voltage_get);
                PrintIOConfig("Robot Ready", data.robot_ready);
                PrintIOConfig("Error", data.error);
            };

            void PrintIOConfig(string label, IOData config)
            {
                printInfo($"  {label}:");
                printInfo($"    Name: {config.name}");
                printInfo($"    Type: {config.type}");
                printInfo($"    Bias: {config.bias}");
                printInfo($"    Enable: {config.enable}");
            }
            ;
            printIOSetting(ioSettingRet);
        }

        // 设置模拟量特性曲线示例
        public void SetCharacteristicCurveDataExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetCharacteristicCurveDataExample");
            Action<CharacteristicCurveData> printCharacteristicCurveData = data =>
            {
                printInfo($"Name: {data.name}");
                printInfo($"Intercept: {data.intercept}");
                printInfo($"Slope: {data.slope}");
                printInfo("Points:");

                foreach (var point in data.points)
                {
                    printInfo($"  ({point.Item1}, {point.Item2})");
                }
            };

            // 下发电流特性曲线参数
            CharacteristicCurveData currentCurveData = new CharacteristicCurveData
            {
                name = "current",
                points = new List<Tuple<double, double>>
                {
                    new Tuple<double, double>(1.0, 200.0),
                    new Tuple<double, double>(3.0, 300.0),
                    new Tuple<double, double>(4.0, 350.0)
                }

            };
            arcwelding.setCurrentCharacteristicCurveData(currentCurveData, out ec);
            printErrorCode("setCurrentCharacteristicCurveData", ec);

            // 读取电流特性曲线参数
            var currentCurveDataRet = arcwelding.getCurrentCharacteristicCurveData(currentCurveData.name, out ec);
            printErrorCode("getCurrentCharacteristicCurveData", ec);
            // 打印电流特性曲线参数
            printCharacteristicCurveData(currentCurveDataRet);

            // 下发电压特性曲线参数
            CharacteristicCurveData voltageCurveData = new CharacteristicCurveData
            {
                name = "voltage",
                points = new List<Tuple<double, double>>
                {
                    new Tuple<double, double>(1.0, 200.0),
                    new Tuple<double, double>(3.0, 300.0),
                }
            };
            arcwelding.setVoltageCharacteristicCurveData(voltageCurveData, out ec);
            printErrorCode("setVoltageCharacteristicCurveData", ec);

            // 读取电压特性曲线参数
            var voltageCurveDataRet = arcwelding.getVoltageCharacteristicCurveData(voltageCurveData.name, out ec);
            printErrorCode("getVoltageCharacteristicCurveData", ec);
            // 打印电压特性曲线参数
            printCharacteristicCurveData(voltageCurveDataRet);

            // 计算电流特性曲线，不保存
            var currentCurveDataCalculated = arcwelding.calculateCurrentCurve(currentCurveData, out ec);
            printErrorCode("calculateCurrentCurve", ec);
            printCharacteristicCurveData(currentCurveDataCalculated);

            // 计算电压特性曲线，不保存
            var voltageCurveDataCalculated = arcwelding.calculateVoltageCurve(voltageCurveData, out ec);
            printErrorCode("calculateVoltageCurve", ec);
            printCharacteristicCurveData(voltageCurveDataCalculated);
        }

        // 设置运行参数示例
        public void SetRunningParamExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetRunningParamExample");
            // 下发运行参数
            ArcWeldRunningParam runningParam = new ArcWeldRunningParam
            {
                test_run_speed = 200,
                wire_feed_speed = 2,
                gas_detect_time = 10,
            };
            arcwelding.setRunningParam(runningParam, out ec);
            printErrorCode("setRunningParam", ec);

            // 读取运行参数
            var runningParamRet = arcwelding.getRunningParam(out ec);
            printErrorCode("getRunningParam", ec);
            printInfo("test_run_speed: " + runningParamRet.test_run_speed);
            printInfo("wire_feed_speed: " + runningParamRet.wire_feed_speed);
            printInfo("gas_detect_time: " + runningParamRet.gas_detect_time);
        }

        // 设置焊机选项和连接焊机示例
        public void SetWelderAndConnectExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetWelderAndConnectExample");
            // 设置焊机（方式一）
            arcwelding.setWelder("ethercat", "aotai", "RL/RPL", 500, out ec);
            printErrorCode("setWelder", ec);

            // 设置焊机（方式二）
            WelderSetting welderSetting = new WelderSetting
            {
                mfr = "aotai",
                model = "RL/RPL",
                protocol = "ethercat",
                current_type = 500,
                current_file = "current1", // 用于模拟量连接
                voltage_file = "voltage1", // 用于模拟量连接
            };
            arcwelding.setWelder(welderSetting, out ec);
            printErrorCode("setWelder", ec);

            // 读取焊机设置
            var welderSettingRet = arcwelding.getWelderSetting(out ec);
            printErrorCode("getWelderSetting", ec);
            printInfo("mfr: " + welderSettingRet.mfr);
            printInfo("model: " + welderSettingRet.model);
            printInfo("protocol: " + welderSettingRet.protocol);
            printInfo("current_type: " + welderSettingRet.current_type);
            printInfo("current_file: " + welderSettingRet.current_file);
            printInfo("voltage_file: " + welderSettingRet.voltage_file);

            // 连接焊机
            arcwelding.connectToWelder(out ec);
            printErrorCode("connectToWelder", ec);

            // 断开焊机
            arcwelding.disconnectFromWelder(out ec);
            printErrorCode("disconnectFromWelder", ec);
        }

        // 切换ENI文件示例
        public void SetEniHaveWeldExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetEniHaveWeldExample");
            // 读取是否连接物理焊机（ENI文件）
            var eniHaveWeld = arcwelding.isEniHaveWeld(out ec);
            printErrorCode("isEniHaveWeld", ec);
            printInfo("eniHaveWeld: " + eniHaveWeld);

            // 设置是否连接物理焊机
            arcwelding.setIsEniHaveWeld(true, out ec);
            printErrorCode("setIsEniHaveWeld", ec);
        }

        // 生效焊接参数
        public void EnableArcData(ArcWelding arcWelding, ref ErrorCode ec)
        {
            printInfo("enter EnableArcData");
            // 不能为虚拟机, 并且需要连接焊机
            ArcData arcDataCustom = new ArcData
            {
                name = "Custom1_name",
                annotation = "Custom1_annotation",
                mode = "low_spatter",
                current_mode = "wire_feed",
                voltage_mode = "separate",
                current = 80,
                voltage = 2,
                weld_speed = 50,
                ramp_time = 200,
                arc_break_param = new ArcBreakParam
                {
                    detect_time = 50,
                    arc_break_option = "stop_and_alarm",
                    restart_back_distance = 0
                }
            };
            arcWelding.enableArcData(arcDataCustom, out ec);
            printErrorCode("enableArcData", ec);
        }

        // 送丝
        public void FeedOnWireExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            // 需要在启用焊机后执行
            printInfo("enter FeedOnWireExample");
            double time = 10;
            // 送丝
            arcwelding.feedOnWire(time, true, out ec); // 送丝和停止送丝时间参数都要大于0.1
            printErrorCode("feedOnWire", ec);

            // 停止送丝
            arcwelding.feedOnWire(time, false, out ec);
            printErrorCode("feedOnWire", ec);
        }

        // 退丝
        public void FeedBackWireExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            // 需要在启用焊机后执行
            printInfo("enter FeedBackWireExample");
            double time = 10;
            // 退丝
            arcwelding.feedBackWire(time, true, out ec);// 退丝和停止退丝时间都要大于0.1
            printErrorCode("feedBackWire", ec);
            // 停止退丝
            arcwelding.feedBackWire(time, false, out ec);
            printErrorCode("feedBackWire", ec);
        }

        // 检气
        public void DetectGasExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            // 需要在启用焊机后执行
            
            printInfo("enter DetectGasExample");
            double time = 10;
            // 检气
            arcwelding.detectGas(time, true, out ec); // 检气和停止检气时间参数都要大于0
            printErrorCode("detectGas", ec);
            // 停止检气
            arcwelding.detectGas(time, false, out ec);
            printErrorCode("detectGas", ec);
        }

        // 获取焊机状态
        public void GetWelderStateExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter GetWelderStateExample");
            var welderState = arcwelding.getWelderStatus(out ec);
            printErrorCode("getWelderStatus", ec);
            printInfo("state: " + welderState.state);
            printInfo("current: " + welderState.current);
            printInfo("voltage: " + welderState.voltage);
            printInfo("speed: " + welderState.speed);
            printInfo("welding_name: " + welderState.welding_name);
            printInfo("arc_welding: " + welderState.arc_welding);
            printInfo("runing_error: " + welderState.running_error.message);
            printInfo("distance: " + welderState.welding_distance);
            printInfo("num: " + welderState.welding_path_num);
        }

        // 打印焊接状态
        public void PrintWeldState(EventInfos info)
        {
            printInfo("enter PrintWeldState");
            double current = info.TryGetValue("current", out object currentObj) ? (double)currentObj : 0.0;
            double voltage = info.TryGetValue("voltage", out object voltageObj) ? (double)voltageObj : 0.0;
            string state = info.TryGetValue("state", out object stateObj) ? (string)stateObj : string.Empty;
            int speed = info.TryGetValue("welding_speed", out object speedObj) ? (int)speedObj : 0;
            ErrorCode error = info.TryGetValue("runningError", out object errorObj) ? (ErrorCode)errorObj : new ErrorCode(0,"");
            string weldingName = info.TryGetValue("welding_name", out object weldingNameObj) ? (string)weldingNameObj : string.Empty;
            int arcwelding = info.TryGetValue("arc_welding", out object arcweldingObj) ? (int)arcweldingObj : 0;
            double distance = (double)info["distance"];

            printInfo("[焊接状态] current: " + current + ", voltage: " + voltage + ", state: " + state + ", speed: " + speed);
            printInfo("weldingName: " + weldingName + ", arcwelding: " + arcwelding+ ", distance: "+ distance);
            printInfo("error: " + error.message);
            if (info.ContainsKey("pathNumber"))
            {
                int pathNumber = (int)info["pathNumber"];
                printInfo("pathNumber: " + pathNumber);
            }
        }

        // 焊接状态监视
        public void SetArcWeldStateWatcher(BaseRobot robot, ref ErrorCode ec)
        {
            printInfo("enter SetArcWeldStateWatcher");
            robot.setEventWatcher(Event.arcWeldState, PrintWeldState, out ec);
            printErrorCode("setEventWatcher", ec);
        }

        // 主动获取焊接状态
        public void QueryWeldStateExample(BaseRobot robot, ref ErrorCode ec)
        {
            // 与焊接状态监视一起用，容易为空
            printInfo("enter QueryWeldStateExample");
            var info = robot.queryEventInfo(Event.arcWeldState, out ec);
            printErrorCode("queryEventInfo", ec);
            PrintWeldState(info);
        }

        public void PrintMoveState(EventInfos info)
        {
            printInfo("enter PrintMoveState");
            var _cmdID = (String)info["cmdID"]; // 指令ID
            var _idx = (int)info["wayPointIndex"]; // 路点下标, 从0开始标号
            var _err = (ErrorCode)info["error"]; // 错误信息
            var _remark = (string)info["remark"]; // 警告信息（相近定位）
            var _reach = (bool)info["reachTarget"]; // 是否到达目标点
            printInfo("[运动执行信息] ID:" + _cmdID + " Index:" + _idx + " 已完成: " + (_reach ? "YES" : "NO") + " error: " + (_err.message) + " remark: " + _remark);
        }

        // move状态监视
        public void setMoveStateWatcher(BaseRobot robot, ref ErrorCode ec)
        {
            printInfo("enter setMoveStateWatcher");
            robot.setEventWatcher(Event.moveExecution, PrintMoveState, out ec);
            printErrorCode("setEventWatcher", ec);
        }

        // 在线修改和保存电流电压
        public void SetAndSaveCurrentVoltageExample(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter SetAndSaveCurrentVoltageExample");
            arcwelding.setCurrentAndVoltage(100, 20, out ec); // 只修改不保存
            printErrorCode("setCurrentAndVoltage", ec);

            arcwelding.saveCurrentAndVoltage(100, 20, out ec); // 只保存不修改
            printErrorCode("saveCurrentAndVoltage", ec);
        }

        // 铆焊
        public void ExampleWelding(ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter ExampleWelding");
            arcwelding.startWelding(100, 0, "unified", out ec); // 一元化模式
            printErrorCode("startWelding", ec);

            arcwelding.startWelding(100, 0, "separate", out ec); // 分别模式
            printErrorCode("startWelding", ec);

            arcwelding.stopWelding(out ec);
            printErrorCode("stopWelding", ec);

        }

        // 指令示例
        public void ExampleCommand(BaseRobot robot, ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter ExampleCommand");
            // 以下点位基于CR7
            // 需要先启用焊机
            arcwelding.setWelder("ethercat", "aotai", "RL/RPL", 500, out ec); // 设置焊机
            printErrorCode("setWelder", ec);
            arcwelding.connectToWelder(out ec); // 启用和连接焊机
            printErrorCode("connectToWelder", ec);

            arcwelding.setArcOnData(ArcOnData.CreateDefault(), out ec);
            arcwelding.setArcData(ArcData.CreateDefault(), out ec);
            arcwelding.setArcOffData(ArcOffData.CreateDefault(), out ec);

            FeedOnWireCommand feedon = new FeedOnWireCommand(0.1, 1.1, true); // 送丝 时间，单位：秒 速度，单位：m/min
            FeedBackWireCommand feedback = new FeedBackWireCommand(0.2, 1.2, true);   // 退丝 时间，单位：秒 速度，单位：m/min

            ArcOnCommand arcon = new ArcOnCommand("default", "default");
            ArcOffCommand arcoff = new ArcOffCommand("default");

            CartesianPosition target = new CartesianPosition
            {
                //trans = new double[] { 0.556769, -0.15, 0.4872 },
                trans = new double[] { 0.315189, -0.15, 0.414397 },
                rpy = new double[] { -Math.PI, 0.0, Math.PI },
            };
            WMoveLCommand wml = new WMoveLCommand(target, 10, 1, "default"); // 直线摆动

            CartesianPosition targetMC = new CartesianPosition
            {
                trans = new double[] { 0.615167, 0.141585, 0.507386 },
                rpy = new double[] { 180.000 * Math.PI / 180, 0.0, -167.039 * Math.PI / 180 },
            };

            CartesianPosition auxMC = new CartesianPosition
            {
                trans = new double[] { 0.583553, 0.134309, 0.628928 },
                rpy = new double[] { 180.000 * Math.PI / 180, 11.286 * Math.PI / 180, -167.039 * Math.PI / 180 },
            };
            WMoveCCommand wmc = new WMoveCCommand(targetMC, auxMC, 10, 1, "default"); // 圆弧摆动                                                              

            WeaveData weaveDataDefault = WeaveData.CreateDefault(); // 设置摆动参数
            weaveDataDefault.amplitude.left = 2;
            weaveDataDefault.amplitude.right = 2;
            weaveDataDefault.weave_length_frequency = 2;
            arcwelding.setWeaveData(weaveDataDefault, out ec);

            WeaveOnCommand weaveon = new WeaveOnCommand("default");
            WeaveOffCommand weaveoff = new WeaveOffCommand();

            robot.setMotionControlMode(MotionControlMode.NrtCommand, out ec);
            printErrorCode("setMotionControlMode", ec);

            String id = "";
            robot.moveAppend(feedon, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(arcon, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(weaveon, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(wml, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(weaveoff, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(arcoff, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(feedback, ref id, out ec);
            printErrorCode("moveAppend", ec);

            robot.setPowerState(true, out ec);
            printErrorCode("setPowerState", ec);

            robot.moveStart(out ec);
            printErrorCode("moveStart", ec);

            robot.stop(out ec); // 暂停
            printErrorCode("stop", ec);

            robot.moveStart(out ec);// 继续
            printErrorCode("moveStart", ec);
        }

        // 整圆指令
        public void WMoveCFExample(BaseRobot robot, ArcWelding arcwelding, ref ErrorCode ec)
        {
            // 点位机型 XMC7-R850-W7G3B4C
            printInfo("enter WMoveCFExample");
            Func<List<double>, double[]> rlPoint2sdkPoint = rlPoint =>
            {
                double[] sdkPoint = new double[6];
                for (int i = 0; i < 3; i++)
                {
                    sdkPoint[i] = rlPoint[i] / 1000.0;
                }
                for (int i = 3; i < 6; i++)
                {
                    sdkPoint[i] = rlPoint[i] / 180.0 * Math.PI;
                }
                return sdkPoint;
            };

            ArcOnCommand arcon = new ArcOnCommand("arcondata1", "arcdata1");
            ArcOffCommand arcoff = new ArcOffCommand("arcoffdata1");
            SegOnCommand segon = new SegOnCommand("segdata1");
            SegOffCommand segooff = new SegOffCommand();
            WeaveOnCommand weaveon = new WeaveOnCommand("weavedata1");
            WeaveOffCommand weaveoff = new WeaveOffCommand();
            List<double> p1point = new List<double> { 556.769126, 101.641184, 358.852436, 158.661084, -17.184105, -148.826026 };
            List<double> p2point = new List<double> { 590.049781, 101.641177, 358.852421, 158.66108, -17.184102, -148.826024 };
            List<double> p3point = new List<double> { 556.769146, 17.242862, 358.852448, 179.999964, -0.000009, -179.999957 };
            List<double> p4point = new List<double> { 556.769126, 101.641184, 358.852436, 179.999964, -0.000009, -179.999957 };
            List<double> p5point = new List<double> { 590.049781, 101.641177, 358.852421, 179.999964, -0.000009, -179.999957 };

            CartesianPosition p1 = new CartesianPosition(rlPoint2sdkPoint(p1point));
            CartesianPosition p2 = new CartesianPosition(rlPoint2sdkPoint(p2point));
            CartesianPosition p3 = new CartesianPosition(rlPoint2sdkPoint(p3point));
            CartesianPosition p4 = new CartesianPosition(rlPoint2sdkPoint(p4point));
            CartesianPosition p5 = new CartesianPosition(rlPoint2sdkPoint(p5point));
            WMoveLCommand wml = new WMoveLCommand(p3, 200, 1);
            WMoveCFCommand wmcf = new WMoveCFCommand(p2, p1, 300 / 180.0 * Math.PI,200,1);
            WMoveCFCommand wmcf2 = new WMoveCFCommand(p4, p5, 300 / 180.0 * Math.PI, 200, 1);

            // 设置旋转类型
            wmcf.rotType = 0; // 不变姿态
            //wmcf.rotType = 1; // 动轴旋转
            //wmcf.rotType = 2; // 定轴旋转

            string id = "";

            // 单独整圆运动
            robot.moveAppend(arcon, ref id, out ec);
            robot.moveAppend(wmcf, ref id, out ec);
            robot.moveAppend(arcoff, ref id, out ec);
            robot.moveStart(out ec);

            // 搭配摆动运动
            //wmcf.setWeaveData("weavedata1", out ec);
            //robot.moveAppend(arcon, ref id, out ec);
            //robot.moveAppend(weaveon, ref id, out ec);
            //robot.moveAppend(wmcf, ref id, out ec);
            //robot.moveAppend(weaveoff, ref id, out ec);
            //robot.moveAppend(arcoff, ref id, out ec);
            //robot.moveStart(out ec);

            // 搭配间断焊运动
            //robot.moveAppend(arcon, ref id, out ec);
            //robot.moveAppend(segon, ref id, out ec);
            //robot.moveAppend(wmcf, ref id, out ec);
            //robot.moveAppend(segooff, ref id, out ec);
            //robot.moveAppend(arcoff, ref id, out ec);
            //robot.moveStart(out ec);

            // 搭配电弧跟踪，需要搭配摆动
            //wmcf.setWeaveData("weavedata1",out ec);
            //wmcf.setTrackData("arctrackdata1", out ec);
            //robot.moveAppend(arcon, ref id, out ec);
            //robot.moveAppend(weaveon, ref id, out ec);
            //robot.moveAppend(wmcf, ref id, out ec);
            //robot.moveAppend(weaveoff, ref id, out ec);
            //robot.moveAppend(arcoff, ref id, out ec);
            //robot.moveStart(out ec);

            // arcdata中设置了断弧回退距离，暂停后继续运动会回退，需要有前置轨迹
            //robot.setDefaultConfOpt(false, out ec);
            //robot.moveAppend(arcon,ref id,out ec);
            //robot.moveAppend(wml, ref id,out ec);
            //robot.moveAppend(wmcf,ref id, out ec);
            //robot.moveAppend(arcoff,ref id,out ec);
            //robot.moveStart(out ec);
            //Thread.Sleep(4000);
            //robot.stop(out ec); // 暂停
            //Thread.Sleep(2000);
            //robot.moveStart(out ec);// 继续
        }

        //打印激光跟踪器状态
        public void PrintLaserSensorState(EventInfos info)
        {
            printInfo("enter PrintLaserSensorState");
            var device_name = (String)info["device_name"];
            var connect = (bool)info["connect"];
            var laser_on = (bool)info["laser_state"];
            var power_on = (bool)info["power_state"]; //注意：明图传感器没有使能状态，这里的使能状态无效

            printInfo("[激光跟踪器状态信息] 设备名称: " + device_name + " 连接:" + (connect ? "YES " : "NO ") + "激光开启:" + (laser_on ? "YES " : "NO ") + "使能开启:" + (power_on ? "YES " : "NO "));
        }

        // 激光跟踪器状态监视
        public void SetLaserSensorStateWatcher(BaseRobot robot, ref ErrorCode ec)
        {
            printInfo("enter SetLaserSensorStateWatcher");
            robot.setEventWatcher(Event.lasertrackState, PrintLaserSensorState, out ec);
            printErrorCode("setEventWatcher", ec);
        }

        //激光跟踪器通信
        void LaserTrackExample(BaseRobot robot, ArcWelding arcwelding, ref ErrorCode ec)
        {
            printInfo("enter LaserTrackExample");
            //设置激光跟踪器配置信息
            LaserSensorCfg cfg;
            cfg.name = "sensor1";
            cfg.ip = "192.168.110.90";
            cfg.port = 502;
            cfg.overtime = 800;
            cfg.communication_cycle = 60;
            cfg.type = LaserSensorType.CRNT;//创想传感器
            //cfg.type = ArcWelding::LaserSensorType.SMART_IMAGE;//明图传感器

            //发送指令设置AddLaserSensorCfg
            arcwelding.setLaserSensorCfg(cfg, out ec);
            printErrorCode("setLaserSensorCfg", ec);

            //查询设备配置信息
            LaserSensorCfg cfg_get = arcwelding.getLaserSensorCfg(cfg.name, out ec);
            printErrorCode("getLaserSensorCfg", ec);
            printInfo("name: " + cfg_get.name + "  ip:" + cfg_get.ip);

            //设置传感器状态监控watch
            SetLaserSensorStateWatcher(robot, ref ec);

            //连接激光跟踪器ConnLaserTrack
            arcwelding.connLaserSensorDev(cfg.name, out ec);
            printErrorCode("connLaserSensorDev", ec);

            //开启焊缝跟踪器，开始获取激光传感器数据OpenLaserTrack
            arcwelding.openLaserTrack(cfg.name, out ec);
            printErrorCode("openLaserTrack", ec);

            //关闭焊缝跟踪器CloseLaserTrack
            arcwelding.closeLaserTrack(cfg.name, out ec);
            printErrorCode("closeLaserTrack", ec);

            //断开连接DisConnLaserTrack
            arcwelding.disconnLaserSensorDev(cfg.name, out ec);
            printErrorCode("disconnLaserSensorDev", ec);

            //删除设备配置信息RemoveLaserSensorCfg
            arcwelding.removeLaserSensorCfg(cfg.name, out ec);
            printErrorCode("removeLaserSensorCfg", ec);

            //设置手眼标定结果
            HandeyeData handeyedata0 = HandeyeData.CreateDefault();
            handeyedata0.mode = true;
            handeyedata0.xyz_abc = new double[] { 29.456, -14.151, 70.047, 4.5006 / 180.0 * Math.PI, 4.0438 / 180.0 * Math.PI, -97.358 / 180.0 * Math.PI };
            handeyedata0.name = "handeyedata0";
            arcwelding.setHandeyeData(handeyedata0, out ec);
            printErrorCode("setHandeyeData", ec);

            //查询手眼标定结果
            String name = "handeyedata0";
            var handeyedata0_get = arcwelding.getHandeyeData(name, out ec);
            printErrorCode("getHandeyeData", ec);
            printInfo("name:" + handeyedata0_get.name + "  xyz_abc: " + handeyedata0_get.xyz_abc[0] + "," + handeyedata0_get.xyz_abc[2] + "," + handeyedata0_get.xyz_abc[3] + "," + handeyedata0_get.xyz_abc[4] + "," + handeyedata0_get.xyz_abc[5] + "}");

            //删除手眼标定结果
            arcwelding.removeHandeyeData(name, out ec);
            printErrorCode("removeHandeyeData", ec);
        }

        // 激光寻位示例
        public async Task LaserSearchExample(BaseRobot robot, ArcWelding arcwelding, ErrorCode ec)
        {
            printInfo("enter LaserSearchExample");
            // 保存手眼标定参数
            HandeyeData handeyedata0 = HandeyeData.CreateDefault();
            handeyedata0.mode = true;
            handeyedata0.xyz_abc = new double[] { 29.456, -14.151, 70.047, 4.5006 / 180.0 * Math.PI, 4.0438 / 180.0 * Math.PI, -97.358 / 180.0 * Math.PI };
            handeyedata0.name = "laserhandeyedata1";
            arcwelding.setHandeyeData(handeyedata0, out ec);
            Debug.WriteLineIf(ec.value != 0, $"setHandeyeData, ec: {ec.message}");

            // 保存寻位参数
            LaserSearchData laserSearchData = new LaserSearchData { name = "lasersearchdata1", job_number = 2, search_type = "point", search_mode = "continuous", step_length = 3, joint_type = "lap_joint" };
            arcwelding.setLaserSearchData(laserSearchData,out ec);
            Debug.WriteLineIf(ec.value != 0, $"setLaserSearchData, ec: {ec.message}");

            CartesianPosition laserSearchPos = new CartesianPosition {rpy = new double[]{ 3.14, 0, 3.14 },trans = new double[]{ 0.563, 0.3, 0.43 } };
            LaserSearchCommand laserSearchCmd = new LaserSearchCommand("laserhandeyedata1","lasersearchdata1",laserSearchPos,1,1);
            var timeout = TimeSpan.FromSeconds(10);

            // CR7 拖拽点位做初始点
            Action moveRobot = () =>
            {
                MoveCommand absj = new MoveCommand { jointTarget = new JointPosition { joints = new List<double> { 0, Math.PI / 6, -Math.PI / 2, 0, -Math.PI / 3, 0 } }, speed = 500 };
                String id = "";
                robot.setPowerState(true, out ec);
                robot.moveAppend(MoveCommand.Type.MoveAbsJ, absj, ref id, out ec);
                robot.setPowerState(true, out ec);
                robot.moveStart(out ec);
                while (true)
                {
                    Thread.Sleep(1000);
                    var st = robot.operationState(out ec);
                    if (st == OperationState.idle || st == OperationState.unknown) break;
                }
            };

            // 连接激光器
            LaserSensorCfg cfg;
            cfg.name = "sensor1";
            cfg.ip = "192.168.110.90";
            cfg.port = 502;
            cfg.overtime = 800;
            cfg.communication_cycle = 60;
            cfg.type = LaserSensorType.CRNT;//创想传感器
            arcwelding.setLaserSensorCfg(cfg, out ec);
            printErrorCode("setLaserSensorCfg", ec);
            SetLaserSensorStateWatcher(robot, ref ec);
            arcwelding.connLaserSensorDev(cfg.name, out ec);
            printErrorCode("connLaserSensorDev", ec);

            // 方式一、单独运动
            // 使用 std::async 启动一个线程执行 executeLaserSearch
            moveRobot();
            var future = Task.Run(() =>
            {
                ErrorCode _ec;
                var r = arcwelding.executeLaserSearch(laserSearchCmd, false, timeout, out _ec);
                Debug.WriteLineIf(ec.value != 0, $"executeLaserSearch, ec: {ec.message}");
                return r;
            });
            // 主线程执行 moveStart
            Thread.Sleep(1000); // 注意处理异步之间的顺序，这里用延时代替
            robot.setPowerState(true, out ec);
            robot.moveStart(out ec);
            Debug.WriteLineIf(ec.value != 0, $"moveStart, ec: {ec.message}");
            // 等待异步线程完成
            var ret = await future;
            var isFound = ret.Item1;
            var pos = ret.Item2;
            printInfo("寻位方式一：");
            printInfo($"isFound: {isFound}, pos: ");
            printInfo(string.Join(", ", pos.trans));
            printInfo("rpy: ");
            printInfo(string.Join(", ", pos.rpy));

            // 方式二、寻位并运动
            moveRobot();
            robot.setPowerState(true, out ec);
            robot.moveReset(out ec);
            var ret2 = arcwelding.executeLaserSearch(laserSearchCmd, true, timeout, out ec);
            Debug.WriteLineIf(ec.value != 0, $"executeLaserSearch, ec: {ec.message}");
            var isFound2 = ret2.Item1;
            var pos2 = ret2.Item2;
            printInfo("寻位方式二：");
            printInfo($"isFound: {isFound2}, pos: ");
            printInfo(string.Join(", ", pos2.trans));
            printInfo("rpy: ");
            printInfo(string.Join(", ", pos2.rpy));
            robot.setPowerState(false, out ec);
        }

        // 示例 - 电弧跟踪，点位适配机型NB4h-R580-XX
        public void arcTrackExample(BaseRobot robot, ArcWelding arcwelding, ref ErrorCode ec)
        {
            //设置电弧跟踪参数
            ArcTrackParam param = ArcTrackParam.CreateDefault();
            param.name = "arctrackdata1";
            param.annotation = "test1";
            param.delay_time = 5;//其他的值类似设置就行，这里直接使用默认值
            arcwelding.setArcTrackParam(param,out ec);

            //获取对应的电弧跟踪参数
            var param_get = arcwelding.getArcTrackParam(param.name,out ec);

            //本例验证时运行于NB4h-R580-3B(注意点位匹配)
            double[] p0 = { 0.357487, 0.000633967, 0.222628, 3.0, 0.0685018, 3.12448 };
            double[] p1 = { 0.357487, 0.143835, 0.222628, 3.13197, 0.0685018, 3.12448 };
            double[] p2 = { 0.456268, 0.000634313, 0.222628, 3.13197, 0.0685026, 3.12448 };
            double[] p3 = { 0.456268, 0.143835, 0.222628, 3.13197, 0.0685024, 3.12448 };
            double[] p4 = { 0.456268, -0.103198, 0.222628, 3.13197, 0.068502, 3.12448 };

            ArcOnCommand arcon = new ArcOnCommand("arcondata1", "arcdata1");
            ArcOffCommand arcoff = new ArcOffCommand("arcoffdata1");
            MoveCommand mj = new MoveCommand {
                cartTarget = new CartesianPosition(p0),
                speed = 100,
                zone = 1
            }; 

            // 第一条，开启电弧跟踪，用跟踪参数arctrackdata1
            WMoveLCommand wml1 = new WMoveLCommand(new CartesianPosition(p1), 20, 1, "weavedata1", "arctrackdata1");
            // 第二条，开启电弧跟踪，用跟踪参数arctrackdata2
            WMoveLCommand wml2 = new WMoveLCommand(new CartesianPosition(p2), 20, 1, "weavedata1", "arctrackdata2");
            // 第三条，电弧跟踪参数为空，不跟踪
            WMoveLCommand wml3 = new WMoveLCommand(new CartesianPosition(p3), 20, 1, "weavedata1");
            // 第四条和第五条，开启电弧跟踪，用跟踪参数arctrackdata2
            WMoveLCommand wml4 = new WMoveLCommand(new CartesianPosition(p4), 20, 1, "weavedata1", "arctrackdata2");
            WMoveLCommand wml5 = new WMoveLCommand(new CartesianPosition(p3), 20, 1, "weavedata1", "arctrackdata2");
            // 第六条，不跟踪
            WMoveLCommand wml6 = new WMoveLCommand(new CartesianPosition(p2), 20, 1, "weavedata1"); // 直线摆动
            WeaveOnCommand weaveon= new WeaveOnCommand("weavedata1");
            WeaveOffCommand weaveoff = new WeaveOffCommand();
            List<ArcWeldingCommand> wmove_list = new List<ArcWeldingCommand> { wml1, wml2, wml3, wml4, wml5, wml6 };

            string id = "";
            string move_id = "";
            robot.setPowerState(true, out ec);
            robot.moveAppend(MoveCommand.Type.MoveJ, mj,ref move_id,out ec);
            robot.moveAppend(arcon, ref id, out ec); 
            robot.moveAppend(weaveon,ref  id, out ec); 
            robot.moveAppend(wmove_list,ref  move_id, out ec); 
            robot.moveAppend(weaveoff, ref id,out ec); 
            robot.moveAppend(arcoff, ref id, out ec); 
            robot.moveStart(out ec); 
        }

        // 示例 - 焊接过程中设置焊接参数
        public void ArcSetExample(xMateRobot robot, ref ErrorCode ec)
        {
            printInfo("enter ArcSetExample");
            // 以下点位基于SR5
            String cmd_id = "";
            ArcOnCommand arc_on_command = new ArcOnCommand();
            ArcOffCommand arc_off_command = new ArcOffCommand();
            MoveCommand absj = new MoveCommand
            {
                jointTarget = new JointPosition { joints = new List<double> { 0, Math.PI / 6, -Math.PI, 0, -Math.PI / 3, 0 } },
                speed = 1000
            };
            MoveCommand l = new MoveCommand
            {
                cartTarget = new CartesianPosition { trans = new double[] { 0.614, 0.136, 0.389 }, rpy = new double[] { -Math.PI, 0, Math.PI } },
                speed = 500
            };
            CartesianPosition wmlTarget1 = new CartesianPosition { trans = new double[] { 0.553, -0.107, 0.309 }, rpy = new double[] { -Math.PI, 0, Math.PI } };
            WMoveLCommand wmovel1 = new WMoveLCommand();
            wmovel1.target = wmlTarget1;
            wmovel1.speed = 500;
            CartesianPosition wmlTarget2 = new CartesianPosition { trans = new double[] { 0.553, 0.107, 0.309 }, rpy = new double[] { -Math.PI, 0, Math.PI } };
            WMoveLCommand wmovel2 = new WMoveLCommand();
            wmovel2.target = wmlTarget2;
            wmovel2.speed = 500;
            wmovel2.arc_set_opt = new ArcSetOpt { arc_data = "arcdata1", ref_start = true, distance = 80 };

            robot.setPowerState(true, out ec);
            printErrorCode("setPowerState", ec);

            robot.moveAppend(MoveCommand.Type.MoveAbsJ, absj, ref cmd_id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(MoveCommand.Type.MoveL, l, ref cmd_id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(arc_on_command, ref cmd_id, out ec);
            printErrorCode("moveAppend", ec);

            List<ArcWeldingCommand> wmls = new List<ArcWeldingCommand> { wmovel1, wmovel2 };
            robot.moveAppend(wmovel1,ref  cmd_id, out ec);
            robot.moveAppend(wmls, ref cmd_id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveAppend(arc_off_command, ref cmd_id, out ec);
            printErrorCode("moveAppend", ec);

            robot.moveStart(out ec);
            printErrorCode("moveStart", ec);

            while (Console.ReadKey().Key != ConsoleKey.Enter) ;
            robot.setPowerState(false, out ec);
            printErrorCode("setPowerState", ec);
        }

        // 示例 - 间断焊。适用CR机型，SR机型需要调整偏移量
        public void segOnExample(BaseRobot robot, ArcWelding arcWelding, ref ErrorCode ec)
        {
            printInfo("enter segOnExample");
            // 根据起始轴角度，计算笛卡尔位姿
            double[] dragPosture = { 0, Math.PI / 6, -Math.PI / 2, 0, -Math.PI / 3, 0 };
            var p_start = robot.calcFk(dragPosture,out ec);
            printInfo($"start pose: {p_start}");

            // 设置间断焊参数
            var segData = new SegData { name = "segdata1",annotation = "segannotation",seg_type = "normal",non_welded_speed = "v5",welded_distance = 15,non_welded_distance = 30 };
            arcWelding.setSegData(segData, out ec);
            // 开始间断焊指令，设置间断焊参数为segdata1
            SegOnCommand segOnCmd = new SegOnCommand("segdata1");
            SegOffCommand segOffCmd = new SegOffCommand();
            // 几条焊接运动指令
            WMoveLCommand seg_wmovel0 = new WMoveLCommand();
            seg_wmovel0.target = p_start;
            seg_wmovel0.speed = 20;
            seg_wmovel0.zone = 0;
            seg_wmovel0.cartTargetOffset.type = CartesianPosition.Offset.Type.offs;
            seg_wmovel0.cartTargetOffset.frame.trans = new double[] { 0, -0.11, -0.12};
            WMoveLCommand seg_wmovel1 = new WMoveLCommand();
            seg_wmovel1.target = p_start;
            seg_wmovel1.speed = 20;
            seg_wmovel1.zone = 0;
            seg_wmovel1.cartTargetOffset.type = CartesianPosition.Offset.Type.offs;
            seg_wmovel1.cartTargetOffset.frame.trans = new double[]{ 0, 0.08, -0.02};
            WMoveCCommand seg_wmc = new WMoveCCommand();
            seg_wmc.target = p_start;
            seg_wmc.aux = p_start;
            seg_wmc.speed = 10;
            seg_wmc.zone = 0;
            seg_wmc.cartTargetOffset.type = CartesianPosition.Offset.Type.offs;
            seg_wmc.cartTargetOffset.frame.trans = new double[]{ 0, -0.05, 0.01};
            seg_wmc.auxPointOffset.type = CartesianPosition.Offset.Type.offs;
            seg_wmc.auxPointOffset.frame.trans = new double[]{ 0, 0.070, 0};

            WMoveLCommand non_seg_wmovl = new WMoveLCommand();
            non_seg_wmovl.target = p_start;
            non_seg_wmovl.speed = 20;
            non_seg_wmovl.zone = 1;
            non_seg_wmovl.cartTargetOffset.type = CartesianPosition.Offset.Type.offs;
            non_seg_wmovl.cartTargetOffset.frame.trans = new double[]{ -0.05, 0, 0};

            ArcOnCommand arcOnCmd = new ArcOnCommand("arcondata1", "arcdata1");
            ArcOffCommand arcOffCmd = new ArcOffCommand("arcoffdata1");
            MoveCommand absj = new MoveCommand{ jointTarget= new JointPosition { joints = new List<double> { 0, Math.PI / 6, -Math.PI/2, 0, -Math.PI / 3, 0 } },speed = 500};
            WeaveOnCommand weave_on_command = new WeaveOnCommand("weavedata1");
            WeaveOffCommand weaveOffCmd = new WeaveOffCommand();

            String id="";
            robot.setPowerState(true, out ec);
            robot.moveAppend(MoveCommand.Type.MoveAbsJ, absj,ref id,out ec);
            robot.moveStart(out ec);
            while (true)
            {
                Thread.Sleep(1000);
                var st = robot.operationState(out ec);
                if (st == OperationState.idle || st == OperationState.unknown) break;
            }
            printInfo("运动到初始点");
                
            robot.moveAppend(arcOnCmd,ref id,out ec);
            robot.moveAppend(weave_on_command, ref id, out ec);
            robot.moveAppend(segOnCmd,ref id,out ec);
            List<ArcWeldingCommand> wmovels = new List<ArcWeldingCommand> { seg_wmovel0, seg_wmovel1 };
            robot.moveAppend(wmovels,ref id,out ec);
            robot.moveAppend(seg_wmc, ref id, out ec);
            robot.moveAppend(segOffCmd,ref id,out ec);
            robot.moveAppend(non_seg_wmovl, ref id, out ec);
            robot.moveAppend(weaveOffCmd, ref id, out ec);
            robot.moveAppend(arcOffCmd, ref id, out ec);
            robot.moveStart(out ec);
        }

        // 钟摆运动示例 - 点位机型XMC7-R850-B0X1A0
        public void arcSetPendulumExample(BaseRobot robot, ArcWelding arcWelding, ref ErrorCode ec)
        {
            string cmd_id = "";
            // 设置起弧/收弧
            ArcData arcData = ArcData.CreateDefault();
            arcData.name = "arcdata1";
            arcWelding.setArcData(arcData, out ec);

            arcData.name = "arcdata2";
            arcData.current = 20;
            arcData.voltage = 15;
            arcWelding.setArcData(arcData, out ec);

            arcData.name = "arcdata3";
            arcData.current = 100;
            arcData.voltage = 20;
            arcData.weld_speed = 15;
            arcWelding.setArcData(arcData, out ec);

            ArcOnData arconData = ArcOnData.CreateDefault();
            arconData.name = "arcondata1";
            arcWelding.setArcOnData(arconData, out ec);

            ArcOffData arcOffData = ArcOffData.CreateDefault();
            arcOffData.name = "arcoffdata1";
            arcWelding.setArcOffData(arcOffData, out ec);

            // 设置摆动
            WeaveData weaveData = WeaveData.CreateDefault();
            weaveData.weave_length_frequency = 3.5;
            weaveData.amplitude.left = 6;
            weaveData.amplitude.right = 4.5;
            arcWelding.setWeaveData(weaveData, out ec);

            ArcOnCommand arc_on_command = new ArcOnCommand("arcondata1", "arcdata1");
            ArcOffCommand arc_off_command = new ArcOffCommand("arcoffdata1");
            WeaveOnCommand weave_on = new WeaveOnCommand();
            WeaveOffCommand weave_off = new WeaveOffCommand();
            MoveCommand absj = new MoveCommand
            {
                jointTarget = new JointPosition { joints = new List<double> { 0.168, 0.369, -0.883, -0.210, -0.637, -0.137 } },
                speed = 1000
            };

            CartesianPosition start1 = new CartesianPosition(new double[] { 0.68015, -0.077702, 0.777555, -2.319, 1.112, -2.228 });
            CartesianPosition startAux1 = new CartesianPosition(new double[] { 0.672849, -0.0777043, 0.777555, -2.319, 1.112, -2.228 });
            CartesianPosition targetAux1 = new CartesianPosition(new double[] { 0.647849, -0.0943, 0.750882, -2.319, 1.112, -2.228 });
            CartesianPosition target1 = new CartesianPosition(new double[] { 0.647849, -0.09473, 0.747882, -2.319, 1.112, -2.228 });
            CartesianPosition targetAux2 = new CartesianPosition(new double[] { 0.437346, -0.2597, 0.793403, -2.319, 1.112, -2.228 });
            CartesianPosition target2 = new CartesianPosition(new double[] { 0.435346, -0.2597, 0.796403, -2.319, 1.112, -2.228 });
            CartesianPosition targetAux3 = new CartesianPosition(new double[] { 0.6117849, -0.14534, 0.666882, -2.319, 1.112, -2.228 });
            CartesianPosition target3 = new CartesianPosition(new double[] { 0.599849, -0.14574, 0.667882, -2.319, 1.112, -2.228 });
            MoveCommand l = new MoveCommand
            {
                cartTarget = start1,
                speed = 500
            };

            // 钟摆
            WMoveLPendulumCommand wp1 = new WMoveLPendulumCommand(startAux1, target1, targetAux1, 20, 0.5, 100, 2);
            WMoveLPendulumCommand wp2 = new WMoveLPendulumCommand(null, target2, targetAux2, 20, 3, 234, 1);
            wp2.arc_set_opt = new ArcSetOpt { arc_data = "arcdata2", ref_start = true, distance = 0 };
            WMoveLPendulumCommand wp3 = new WMoveLPendulumCommand(null, target3, targetAux3, -1, 3.1, 4, 5);
            wp3.arc_set_opt = new ArcSetOpt { arc_data = "arcdata3", ref_start = true, distance = 0 };

            robot.setPowerState(true, out ec);
            robot.moveAppend(MoveCommand.Type.MoveAbsJ, absj, ref cmd_id, out ec);
            robot.moveAppend(MoveCommand.Type.MoveL, l, ref cmd_id, out ec);
            robot.moveAppend(arc_on_command, ref cmd_id, out ec);
            robot.moveAppend(wp1, ref cmd_id, out ec);
            robot.moveAppend(wp2, ref cmd_id, out ec);
            robot.moveAppend(wp3, ref cmd_id, out ec);
            robot.moveAppend(arc_off_command, ref cmd_id, out ec);
            robot.moveStart(out ec);

            while (Console.KeyAvailable)
            {
                ConsoleKeyInfo keyInfo = Console.ReadKey(true);
            }

            robot.setPowerState(false, out ec);
        }

        public void getRobotCfgDHparam(BaseRobot robot, ref ErrorCode ec)
        {
            printInfo("enter getRobotCfg_DHparam");
            var ret = robot.getRobotCfg_DHparam(false, out ec);
            printErrorCode("getRobotCfg_DHparam", ec);
        }

        void PrintAnticollisionState(EventInfos info)
        {
            printInfo("enter PrintAnticollisionState");
            var signal = (String)info["signal"];
            var enable = (bool)info["enable"];
            var block = (bool)info["block"];
            var countdown = (int)info["countdown"];
            printInfo("anticollision: \n" +
                              $"signale: {signal}\n" +
                              $"enable: {enable}\n" +
                              $"block: {block}\n" +
                              $"countdown: {countdown}");
        }

        // 设置防撞器
        void SetAnticollision(BaseRobot robot, ArcWelding arcWelding, ref ErrorCode ec)
        {
            robot.setEventWatcher(Event.anticollisionState, PrintAnticollisionState, out ec);
            printErrorCode("setEventWatcher", ec);

            arcWelding.setAnticollision("DI0_0", true, false, 30, out ec);
            printErrorCode("setAnticollision", ec);

            var ret = arcWelding.getAnticollisionState(out ec);
            printErrorCode("getAnticollisionState", ec);

            printInfo("anticollision: \n" +
                                  $"signale: {ret.signal}\n" +
                                  $"enable: {ret.enable}\n" +
                                  $"block: {ret.block}\n" +
                                  $"countdown: {ret.countdown}");

            while(true) { };
        }

        void PrintLogReporter(EventInfos info)
        {
            printInfo("enter PrintLogReporter");
            var ecode = (int)info["ecode"];
            printInfo($"logReporter:{ecode}");
            var loginfos = this.robot.queryControllerLog(10, LogInfo.Level.info, out ec); // 查询最近10条的三个等级的控制器日志
            loginfos.AddRange(this.robot.queryControllerLog(10, LogInfo.Level.warning, out ec));
            loginfos.AddRange(this.robot.queryControllerLog(10, LogInfo.Level.error, out ec));
            int i;
            for (i = 0; i < loginfos.Count; i++)
            {
                if (ecode == loginfos[i].id)
                {
                    printInfo($"时间:{loginfos[i].timestamp}");
                    printInfo($"内容:{loginfos[i].content}");
                    printInfo($"修复办法:{loginfos[i].repair}");
                    break;
                }
            }
            if (i == loginfos.Count)
            {
                printInfo($"not find id = {ecode}");
            }
        }

        // 设置日志上报监视
        void SetLogReporterEvent(BaseRobot robot, ref ErrorCode ec)
        {
            printInfo("enter SetLogReporterEvent");
            robot.setEventWatcher(Event.logReporter, PrintLogReporter, out ec);
            while (true) { }
            ;
        }

        void printInfo(String info)
        {
            Debug.WriteLine(info);
            if (toInfoBox)
            {
                ArcWeldingForm.arcWeldingFormInstance.InfoBox = info;
            } 
        }

        void printErrorCode(String funcName, ErrorCode ec)
        {
            if(ec.value != 0)
            {
                String info = funcName + ": " + ec.message;
                Debug.WriteLine(info);
                if (toInfoBox)
                {
                    ArcWeldingForm.arcWeldingFormInstance.InfoBox = info;
                }
            }
        }
        xMateRobot robot = new xMateRobot("192.168.110.129");
        public void AllDemo()
        {
            try
            {
                ArcWelding arcWelding = robot.arcwelding();
                ErrorCode ec = new ErrorCode(0, "");
                //EnableArcData(arcWelding, ref ec); // 生效焊接参数
                //SetArcOnDataExample(arcWelding, ref ec); // 读写起弧参数
                //SetArcDataExample(arcWelding, ref ec); // 读写焊接参数
                //SetArcOffDataExample(arcWelding, ref ec); // 读写收弧参数
                //SetWeaveDataExample(arcWelding, ref ec); // 读写摆动参数
                //SetSegDataExample(arcWelding, ref ec); // 读写间断焊参数
                //SetLaserTrackDataExample(arcWelding, ref ec); // 读写激光跟踪参数
                //SetLaserSearchDataExample(arcWelding, ref ec); // 读写激光寻位参数
                //SetArcTrackDataExample(arcWelding, ref ec); // 读写电弧跟踪参数
                //SetIOSettingExample(arcWelding, ref ec); // 读写IO设置
                //SetCharacteristicCurveDataExample(arcWelding, ref ec); // 读写特性曲线参数
                //SetRunningParamExample(arcWelding, ref ec); // 读写运行参数
                //SetWelderAndConnectExample(arcWelding, ref ec); // 焊机设置
                //SetEniHaveWeldExample(arcWelding, ref ec); // ENI焊接设置
                //FeedOnWireExample(arcWelding, ref ec);
                //FeedBackWireExample(arcWelding, ref ec);
                //DetectGasExample(arcWelding, ref ec);
                GetWelderStateExample(arcWelding, ref ec);
                //SetArcWeldStateWatcher(robot, ref ec);
                //QueryWeldStateExample(robot, ref ec);
                //setMoveStateWatcher(robot, ref ec);
                //SetAndSaveCurrentVoltageExample(arcWelding, ref ec);
                //ExampleWelding(arcWelding, ref ec);
                //ExampleCommand(robot, arcWelding, ref ec);
                //WMoveCFExample(robot, arcWelding, ref ec);
                //SetLaserSensorStateWatcher(robot, ref ec);
                //LaserTrackExample(robot, arcWelding, ref ec);
                //LaserSearchExample(robot, arcWelding, ec);
                //arcTrackExample(robot, arcWelding,ref ec);
                //ArcSetExample(robot, ref ec);
                //segOnExample(robot, arcWelding,ref ec);
                getRobotCfgDHparam(robot, ref ec);
                //SetAnticollision(robot, arcWelding, ref ec);
                //SetLogReporterEvent(robot, ref ec);
                while (true) { }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
    }
}
