# xCore SDK 机器人控制接口 C#版本

## 兼容性

### 机器人控制器

* 需使用定制控制器版本 xCore >= v3.0.2.C130.2025xxxx

### 编译

* .NET Framework >= 7.0
* 支持/clr编译选项，不支持/clr:netcore

## 工程说明及使用方法

### 文件说明

* `xCoreSDK-CSharp\xcore.lib` xCore-SDK DLL, XML文档
* `MainForm` 基础功能接口实例
* `ApplicationForm` 其它示例，目前只包含机器人状态数据读取
* `examples` 包括各个接口调用方法的示例

### 使用方法

* 使用VS2017或更高版本打开`xCoreSDK-CSharp.sln`
* 编译平台需要选择"x64"

### 定制版本示例说明

#### 焊接应用 - 激光跟踪

* 需要先给机器人创建好寄存器，建立和激光传感器的通信
* 点击`运行激光跟踪示例` ，执行一条直线运动的激光跟踪。需要先给出正确的工具坐标、传感器手眼标定数据，并适配点位
* 点击 `停止运行` 停止运动及跟踪

#### 焊接应用 - 点位记录

* 除机器人地址外，增加`本机地址`, 用于UDP接收状态数据地址绑定。注意防火墙设置为允许该程序的网络通信
* 时间同步：首次升级后需要配置NTP服务端地址，可点击`配置NTP`, 示例使用本机地址作为服务端地址
* 点位记录功能：点击`开始记录`,先和服务端同步一次时间, 然后按照设定的周期开始获取数据，并写入文件
* 点击`运行示例`后，机器人将在零点和各轴85°之间往复运动两次，请确认周围环境后再运行
* `停止记录`将停止接收数据

#### 无末端拖动

* 勾选`无末端`后打开拖动，无需按住末端按键即可拖动

#### 导轨

* 示例界面仅添加了导轨点动，更多导轨相关接口见`xMateRobotDemo.Example_MoveWithRail`

#### 硬件设置

xCore SDK通过以太网（TCP/IP）连接机器人。C#只包含非实时接口，对网络的要求并不高，通过有线或无线连接皆可，使工作站PC和机器人连接同一局域网。

#### 机器人设置

* xCore SDK在使用前不需要通过Robot Assist打开相关功能。
* xCore SDK为需要授权的功能，如遇“功能未授权”的错误信息，请联系客户支持人员
