/**
 * @file calibrate_example.cpp
 * @brief 标定功能sdk示例
 *
 * @copyright Copyright (C) 2024 ROKAE (Beijing) Technology Co., LTD. All Rights Reserved.
 * Information in this file is the intellectual property of Rokae Technology Co., Ltd,
 * And may contains trade secrets that must be stored and viewed confidentially.
 */
#include "print_helper.hpp"
#include "rokae/data_types.h"
#include "rokae/model.h"
#include "rokae/robot.h"
#include "rokae/utility.h"
#include <iostream>
#include <thread>
using namespace rokae;
using namespace std;

// 力传感器标定
void calibrateForceSensor(xMateRobot &robot, std::error_code &ec) {
  Toolset toolset;
  toolset.load.mass = 0.0;// 先设置负载

  // 标定所有轴
  robot.calibrateForceSensor(true, 0, ec);// 非阻塞，需要100ms左右
  cout << "calibrateForceSensor: " << ec.value() << "," << ec.message() << endl;

  // 标定单轴
  int axis_index = 2;                               // 例如标定3轴
  robot.calibrateForceSensor(false, axis_index, ec);// 非阻塞，需要100ms左右
  cout << "calibrateForceSensor: " << ec.value() << "," << ec.message() << endl;
}

int main() {
  try {
    std::string ip = "192.168.0.160";
    std::error_code ec;
    xMateRobot robot(ip);
    calibrateForceSensor(robot, ec);

  } catch (const rokae::Exception &e) {
    std::cerr << e.what();
  }
  return 0;
}