using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using xCoreSDK_CSharp.examples;
using rokae.clr;
using System.Reflection.Metadata;

namespace xCoreSDK_CSharp
{
    public partial class WeldForm : Form, FormInterface
    {
        WeldingDemo demo;
        xMateRobotDemo robotDemo;
        internal static WeldForm weldFormInstance;
        internal string InfoBox
        {
            get { return richTextBoxExecInfo.Text.ToString(); }
            set
            {
                if (richTextBoxExecInfo.InvokeRequired)
                {
                    richTextBoxExecInfo.Invoke(new Action<string>(info =>
                    {
                        AppendRichBox(this.richTextBoxExecInfo, info);
                    }), value);
                    return;
                }

                AppendRichBox(richTextBoxExecInfo, value);
            }
        }

        public WeldForm()
        {
            InitializeComponent();
            weldFormInstance = this;
        }

        void FormInterface.setRobotInstance(xMateRobotDemo robotInstance)
        {
            robotDemo = robotInstance;
            demo.robotDemo = robotInstance;
        }

        private void WeldForm_Load(object sender, EventArgs e)
        {
            demo = new WeldingDemo();
        }

        private void AppendRichBox(RichTextBox box, string content)
        {
            if (string.IsNullOrEmpty(content))
            {
                return;
            }

            box.AppendText(content + System.Environment.NewLine);
            box.ScrollToCaret();
        }

        private void PrintExecInfo(string content)
        {
            if (richTextBoxExecInfo.InvokeRequired)
            {
                richTextBoxExecInfo.Invoke(new Action<string>(info =>
                {
                    AppendRichBox(this.richTextBoxExecInfo, info);
                }), content);
                return;
            }

            AppendRichBox(richTextBoxExecInfo, content);
        }
        private void printErrorCode(string operate, ErrorCode _ec)
        {
            if (_ec.value != 0)
            {
                PrintExecInfo(operate + ": " + _ec.message);
            }
        }

        private void button_RunTest_Click(object sender, EventArgs e)
        {
            demo.laserTrackExample();
        }

        private void buttonRunExample_Click(object sender, EventArgs e)
        {
            robotDemo.Example_MoveWithRail();
            PrintExecInfo($"运行示例指令 {robotDemo.demo_TestReadData()}");
        }

        private void buttonConfigNtp_Click(object sender, EventArgs e)
        {  
            // 示例使用上位机作为NTP服务端
            robotDemo.robot.configNtp(textBox_ServerIp.Text, out ErrorCode ec);
            if (ec.value == 0)
            {
                PrintExecInfo("已配置");
            }
            else
            {
                printErrorCode("配置NTP", ec);
            }
        }

        private void buttonSyncTime_Click(object sender, EventArgs e)
        {
            PrintExecInfo($"开始记录 {robotDemo.demo_StartRecordingPos()}");
        }

        private void buttonStopRec_Click(object sender, EventArgs e)
        {
            PrintExecInfo($"停止记录 {robotDemo.demo_StopRecordingPos()}");
        }

        private void buttonClearLog_Click(object sender, EventArgs e)
        {
            richTextBoxExecInfo.Clear();
        }

        private void button_stop_Click(object sender, EventArgs e)
        {
            demo.stopTracking();
            PrintExecInfo("停止运行");
        }

        private void button_multi_Click(object sender, EventArgs e)
        {
           demo.multi();
        }
    }
}
