﻿using rokae.clr;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace xCoreSDK_CSharp
{
    internal class StandardRobotDemo
    {
        // 工业六轴机型
        private StandardRobot robot = new StandardRobot();

        /// <summary>
        /// 示例 - 连接到机器人
        /// </summary>
        /// <param name="remoteIP">机器人地址</param>
        public void connect(string remoteIP)
        {
            robot.connectToRobot(remoteIP);
        }

        public void Example_OtherOperation()
        {            
            ErrorCode ec;

            Frame new_bf = new Frame(robot.baseFrame(out ec));
            new_bf.trans[0] += 0.1;
            // 设置基坐标系为当前基坐标系X +0.1m
            // 基坐标系需要重启控制器后生效
            Console.WriteLine($"设置基坐标系为 {new_bf.trans[0]}, {new_bf.trans[1]}, " +
                $"{new_bf.trans[2]}, {new_bf.rpy[0]}, {new_bf.rpy[1]}, {new_bf.rpy[2]}");
            robot.setBaseFrame(new_bf, out ec);

            // 恢复设置
            Console.WriteLine("恢复基座标设置");
            new_bf.trans[0] -= 0.1;
            robot.setBaseFrame(new_bf, out ec);
        }
    }
}
