#!/bin/sh

#Find usb device directory.
USBNAME=`cat /proc/partitions | /bin/grep -v mmcblk0 | sed -n '$p' | awk '{print $4}'`
#echo $USBNAME

if [ "$USBNAME" == "" ];then
  exit 0
fi

PATH_UPDATE="/media/$USBNAME/package/update"
PATH="/media/$USBNAME/package"
PATH_ROKAE="/media/$USBNAME/package/rokae.zip"

if [[ ! -s $PATH_UPDATE || ! -s $PATH_ROKAE ]]; then
  exit 0
fi

#Start from here
#Touch screen var
export PATH PS1 OPIEDIR QPEDIR QTDIR EDITOR TERM
export TSLIB_TSDEVICE=/dev/input/touchscreen0
export TSLIB_CONFFILE=/etc/ts.conf
export TSLIB_PLUGINDIR=/usr/lib/ts
export TSLIB_CALIBFILE=/etc/pointercal
export TSLIB_CONSOLEDEVICE=none
export TSLIB_FBDEVICE=/dev/fb0
export QWS_MOUSE_PROTO="Tslib:/dev/input/touchscreen0 MouseMan:/dev/input/mouse1"
export QWS_KEYBOARD="linuxinput:/dev/input/event1"

name="Robot-HMI"
ps_out=`/bin/ps -ef | /bin/grep $name | /bin/grep -v 'grep' | /bin/grep -v $0`
result=$(echo $ps_out | /bin/grep "$name")

if [ "$result" == "" ]; then
  #Run qt server with -qws option when Robot-HMI not running
  $PATH_UPDATE $PATH -qws
else
  #Try execute ForceUpdate program without -qws option
  $PATH_UPDATE $PATH || $PATH_UPDATE $PATH -qws
fi
