#!/bin/sh
#1. 设置定时器，检测到文件有改动后，每10分钟备份一次workspace，命名为workspace_20184121409#,存放于/home/luoshi/nfs_space/workspace_backup/目录下
#2. 检查该路径下文件个数，大于5删除时间最早的文件；检查该路径下文件大小，达到100MB删除时间最早的#文件。
# crontab -e
# */10*** /...sh 隔10min运行该脚本。

PATH=/bin:/sbin:/usr/bin:usr/local/bin:/usr/local/sbin:~/bin
export PATH
work="/home/luoshi/nfs_space/workspace/"
distin="/home/luoshi/nfs_space/workspace_backup"

#建立目标备份目录 

    if [ ! -d "$distin" ]; then
	mkdir "$distin"
    fi
#打开备份目录，生成原目录的md5校验文件保存到file_pre.md5中

    cd ${distin}    
    if [ ! -f "file.md5" ]; then
	find ${work} -type f -exec  md5sum {} \; >file.md5
    fi
#等待1.5分钟后检测是否发生改变

    md5sum -c ${distin}/file.md5
    diff_or_same=`echo $?`
    find ${work} -type f -exec md5sum {} \; >file.md5

#如果文件发生了改动，进行复制操作    

    if [ ${diff_or_same} -eq 1 ];then

#  rsync -av --backup-dir=${distin} --suffix=$(date +%Y%m%d%H%M)  $work     

	suffix=`date +%Y%m%d%H%M`
        cp -a  /home/luoshi/nfs_space/workspace ./workspace"_${suffix}"

#时间间隔在1分钟之内的话会把workspace也拷贝进新建的文件夹里面。

#${workworkspace_backup 路径下文件个数大于5
	file_num=`ls -lt ${distin} | grep "^d" | wc -l`
	echo  ${file_num}
	while [ ${file_num} -gt 5 ]
	do 
	    file_name=`ls -lt ${distin} |grep "^d"| tail -1 |awk '{print $9}'`
	    echo ${file_name}
	    rm -rf ${distin}/${file_name}
	    file_num=`ls -lt ${distin} | grep "^d" | wc -l`
	    echo ${file_num}
	done
	echo "finished!" 
 #${work}workspace_backup 路径下文件大于100MB
	total_size=`du -s ${distin}|awk '{print $1}'`  
	echo ${total_size}
	while [ ${total_size} -gt 102400 ]
	do 
	    file_name=`ls -lt ${distin} |grep "^d"| tail -1 |awk '{print $9}'`
	    echo ${filename}
	    rm -rf ${distin}/${file_name} 
	    total_size=`du -s ${distin}|awk '{print $1}'`
	done
	echo "finished!"
    fi


